/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.parser;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.cdap.wrangler.api.DirectiveConfig;
import io.cdap.wrangler.api.DirectiveContext;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.Charset;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class ConfigDirectiveContext
implements DirectiveContext {
    private DirectiveConfig config;

    public ConfigDirectiveContext(DirectiveConfig config) {
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConfigDirectiveContext(URL url) throws IOException {
        try (CloseableHttpClient client = null;){
            HttpGet get = new HttpGet(url.toString());
            get.addHeader("Content-type", "application/json; charset=UTF-8");
            client = HttpClients.createDefault();
            this.config = (DirectiveConfig)client.execute((HttpUriRequest)get, (ResponseHandler)new ServiceResponseHandler());
        }
    }

    public boolean hasAlias(String directive) {
        return this.config.hasAlias(directive);
    }

    public String getAlias(String directive) {
        return this.config.getAliasName(directive);
    }

    public boolean isExcluded(String directive) {
        return this.config.isExcluded(directive);
    }

    private class ServiceResponseHandler
    implements ResponseHandler<DirectiveConfig> {
        private ServiceResponseHandler() {
        }

        public DirectiveConfig handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            StatusLine statusLine = response.getStatusLine();
            HttpEntity entity = response.getEntity();
            if (statusLine.getStatusCode() >= 300) {
                throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
            }
            if (entity == null) {
                throw new ClientProtocolException("Response contains no content");
            }
            Gson gson = new GsonBuilder().create();
            InputStreamReader reader = new InputStreamReader(entity.getContent(), Charset.forName("UTF-8"));
            DirectiveConfig config = (DirectiveConfig)gson.fromJson((Reader)reader, DirectiveConfig.class);
            return config;
        }
    }
}

