/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.dq;

import io.cdap.wrangler.dq.DataType;
import io.cdap.wrangler.dq.DateTimePattern;
import java.math.BigInteger;
import java.util.regex.Pattern;

public class TypeInference {
    private static final Pattern patternInteger = Pattern.compile("^(\\+|-)?\\d+$");
    private static final Pattern patternDouble = Pattern.compile("^[-+]?([0-9]+([,\\.][0-9]+)?|([0-9]{1,3}(((,[0-9]{3})*(\\.[0-9]+)?|((\\.[0-9]{3})*|([ \u00a0\u2007\u202f][0-9]{3})*)(,[0-9]+)?))))([ ]?[eE][-+]?[0-9]+)?$");

    public static boolean isDouble(String value) {
        return !TypeInference.isEmpty(value) && patternDouble.matcher(value).matches();
    }

    public static boolean isInteger(String value) {
        return !TypeInference.isEmpty(value) && patternInteger.matcher(value).matches();
    }

    public static boolean isNumber(String value) {
        return TypeInference.isDouble(value) || TypeInference.isInteger(value);
    }

    public static BigInteger getBigInteger(String value) {
        BigInteger bint = null;
        try {
            bint = new BigInteger(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
        return bint;
    }

    public static boolean isBoolean(String value) {
        if (TypeInference.isEmpty(value)) {
            return false;
        }
        return !(value.trim().length() != 4 && value.trim().length() != 5 || !"true".equalsIgnoreCase(value) && !"false".equalsIgnoreCase(value));
    }

    public static boolean isDate(String value) {
        return DateTimePattern.isDate(value);
    }

    public static boolean isTime(String value) {
        return DateTimePattern.isTime(value);
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean isValid(DataType type, String value) {
        switch (type) {
            case BOOLEAN: {
                return TypeInference.isBoolean(value);
            }
            case INTEGER: {
                return TypeInference.isInteger(value);
            }
            case DOUBLE: {
                return TypeInference.isDouble(value);
            }
            case DATE: {
                return TypeInference.isDate(value);
            }
            case STRING: {
                return true;
            }
        }
        return false;
    }

    public static DataType getDataType(String value) {
        if (TypeInference.isEmpty(value)) {
            return DataType.EMPTY;
        }
        if (TypeInference.isBoolean(value)) {
            return DataType.BOOLEAN;
        }
        if (TypeInference.isInteger(value)) {
            return DataType.INTEGER;
        }
        if (TypeInference.isDouble(value)) {
            return DataType.DOUBLE;
        }
        if (TypeInference.isDate(value)) {
            return DataType.DATE;
        }
        if (TypeInference.isTime(value)) {
            return DataType.TIME;
        }
        return DataType.STRING;
    }
}

