/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.codec;

import com.google.gson.Gson;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.codec.AbstractAvroDecoder;
import io.cdap.wrangler.codec.DecoderException;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.util.Utf8;

public class BinaryAvroDecoder
extends AbstractAvroDecoder {
    private final Gson gson = new Gson();

    public BinaryAvroDecoder(Schema schema) {
        super(schema);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<Row> decode(byte[] bytes) throws DecoderException {
        ArrayList<Row> rows = new ArrayList<Row>();
        BinaryDecoder decoder = null;
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        try {
            decoder = DecoderFactory.get().binaryDecoder((InputStream)in, null);
            try {}
            catch (EOFException e2222222) {
                try {
                    in.close();
                    return rows;
                }
                catch (IOException e2222222) {
                    return rows;
                }
            }
        }
        catch (AvroTypeException e) {
            try {
                throw new DecoderException(e.getMessage());
                catch (IOException e3) {
                    throw new DecoderException("Issue creating AVRO binary decoder. Verify the schema.");
                }
            }
            catch (Throwable throwable) {
                try {
                    in.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        while (true) {
            GenericRecord gRecord = (GenericRecord)this.getReader().read(null, (Decoder)decoder);
            List fields = this.getSchema().getFields();
            Row r = new Row();
            for (Schema.Field field : fields) {
                Object object = gRecord.get(field.name());
                if (object instanceof Utf8) {
                    Utf8 o = (Utf8)object;
                    object = o.toString();
                } else if (object instanceof Map || object instanceof List) {
                    object = this.gson.toJson(object);
                }
                r.add(field.name(), object);
            }
            rows.add(r);
        }
    }
}

