/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.functions;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.spi.json.GsonJsonProvider;
import com.jayway.jsonpath.spi.json.JsonProvider;
import com.jayway.jsonpath.spi.mapper.GsonMappingProvider;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class JsonFunctions {
    public static final Configuration GSON_CONFIGURATION = Configuration.builder().mappingProvider((MappingProvider)new GsonMappingProvider()).jsonProvider((JsonProvider)new GsonJsonProvider()).options(new Option[]{Option.SUPPRESS_EXCEPTIONS}).build();
    private static final JsonParser PARSER = new JsonParser();
    private static final Gson GSON = new GsonBuilder().serializeNulls().create();

    private JsonFunctions() {
    }

    @Deprecated
    public static JsonElement select(String json, String path, String ... paths) {
        JsonElement element = PARSER.parse(json);
        return JsonFunctions.select(element, path, paths);
    }

    @Deprecated
    public static JsonElement select(String json, boolean toLower, String path, String ... paths) {
        JsonElement element = PARSER.parse(json);
        return JsonFunctions.select(element, toLower, path, paths);
    }

    @Deprecated
    public static JsonElement select(JsonElement element, String path, String ... paths) {
        return JsonFunctions.select(element, true, path, paths);
    }

    @Deprecated
    public static JsonElement select(JsonElement element, boolean toLower, String path, String ... paths) {
        if (toLower) {
            element = JsonFunctions.keysToLower(element);
        }
        DocumentContext context = JsonPath.using((Configuration)GSON_CONFIGURATION).parse((Object)element);
        if (paths.length == 0) {
            return (JsonElement)context.read(path, new Predicate[0]);
        }
        JsonArray array = new JsonArray();
        array.add((JsonElement)context.read(path, new Predicate[0]));
        for (String p : paths) {
            array.add((JsonElement)context.read(p, new Predicate[0]));
        }
        return array;
    }

    @Deprecated
    public static JsonElement drop(String json, String field, String ... fields) {
        JsonElement element = PARSER.parse(json);
        return JsonFunctions.drop(element, field, fields);
    }

    @Deprecated
    public static JsonElement drop(JsonElement element, String field, String ... fields) {
        block4: {
            block3: {
                if (!element.isJsonObject()) break block3;
                JsonObject object = element.getAsJsonObject();
                Set entries = object.entrySet();
                for (Map.Entry next : entries) {
                    JsonFunctions.drop((JsonElement)next.getValue(), field, fields);
                }
                object.remove(field);
                for (String fld : fields) {
                    object.remove(fld);
                }
                break block4;
            }
            if (!element.isJsonArray()) break block4;
            JsonArray object = element.getAsJsonArray();
            for (int i = 0; i < object.size(); ++i) {
                JsonElement arrayElement = object.get(i);
                if (!arrayElement.isJsonObject()) continue;
                JsonFunctions.drop(arrayElement, field, fields);
            }
        }
        return element;
    }

    @Deprecated
    public static JsonElement keysToLower(JsonElement element) {
        if (element.isJsonObject()) {
            JsonObject newObject = new JsonObject();
            JsonObject object = element.getAsJsonObject();
            Set entries = object.entrySet();
            for (Map.Entry next : entries) {
                String name = (String)next.getKey();
                JsonElement child = (JsonElement)next.getValue();
                newObject.add(name.toLowerCase(), JsonFunctions.keysToLower(child));
            }
            return newObject;
        }
        if (element.isJsonArray()) {
            JsonArray newArray = new JsonArray();
            JsonArray array = element.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                newArray.add(JsonFunctions.keysToLower(array.get(i)));
            }
            return newArray;
        }
        return element;
    }

    @Deprecated
    public static String join(JsonElement element, String separator) {
        StringBuilder sb = new StringBuilder();
        if (element instanceof JsonArray) {
            JsonArray array = element.getAsJsonArray();
            for (int i = 0; i < array.size(); ++i) {
                JsonElement value = array.get(i);
                if (value == null) continue;
                if (value instanceof JsonPrimitive) {
                    sb.append(value);
                }
                sb.append(separator);
            }
        }
        return sb.toString();
    }

    @Deprecated
    public static String stringify(JsonElement element) {
        if (element == null) {
            return "null";
        }
        return element.toString();
    }

    @Deprecated
    public static JsonElement parse(String json) {
        return JsonFunctions.parse(json, false);
    }

    @Deprecated
    public static JsonElement parse(String json, boolean toLower) {
        JsonElement element = PARSER.parse(json);
        if (toLower) {
            element = JsonFunctions.keysToLower(element);
        }
        return element;
    }

    public static JsonElement Parse(String json) {
        try {
            JsonElement element = PARSER.parse(json);
            return element;
        }
        catch (JsonSyntaxException e) {
            return JsonNull.INSTANCE;
        }
    }

    public static boolean IsValid(String json) {
        try {
            PARSER.parse(json);
            return true;
        }
        catch (JsonSyntaxException e) {
            return false;
        }
    }

    public static boolean IsNull(JsonElement element) {
        return element == null || element.isJsonNull();
    }

    public static boolean IsObject(JsonElement element) {
        return element != null && element.isJsonObject();
    }

    public static boolean IsArray(JsonElement element) {
        return element != null && element.isJsonArray();
    }

    public static JsonElement Select(JsonElement element, String path, String ... paths) {
        DocumentContext context = JsonPath.using((Configuration)GSON_CONFIGURATION).parse((Object)element);
        if (paths.length == 0) {
            return (JsonElement)context.read(path, new Predicate[0]);
        }
        JsonArray array = new JsonArray();
        array.add((JsonElement)context.read(path, new Predicate[0]));
        for (String p : paths) {
            array.add((JsonElement)context.read(p, new Predicate[0]));
        }
        return array;
    }

    public static String Stringify(JsonElement element) {
        if (element == null) {
            return GSON.toJson((JsonElement)JsonNull.INSTANCE);
        }
        return GSON.toJson(element);
    }

    @Nullable
    public static int ArrayLength(JsonArray array) {
        if (array != null) {
            return array.size();
        }
        return 0;
    }
}

