/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.functions;

import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.gson.JsonElement;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.functions.JsonFunctions;
import io.cdap.wrangler.utils.StructuredRecordJsonConverter;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;

public final class DDL {
    private DDL() {
    }

    public static Schema parse(String json) throws IOException {
        return Schema.parseJson((String)json);
    }

    public static Schema parsesql(String sql) throws IOException {
        return Schema.parseSQL((String)sql);
    }

    public static Schema parse(Schema schema) {
        return schema;
    }

    public static StructuredRecord parse(StructuredRecord record) {
        return record;
    }

    public static JsonElement toJson(StructuredRecord record) throws IOException {
        return JsonFunctions.Parse(StructuredRecordJsonConverter.toJsonString(record));
    }

    public static boolean hasField(StructuredRecord record, String name) {
        Schema.Field field = record.getSchema().getField(name);
        return field != null;
    }

    public static Schema drop(Schema schema, String path) {
        return DDL.drop(schema, path, path);
    }

    public static Schema drop(Schema schema, String path, String ... paths) {
        Schema mutatedSchema = DDL.drop(schema, path, path);
        for (String otherPath : paths) {
            mutatedSchema = DDL.drop(mutatedSchema, otherPath, otherPath);
        }
        return mutatedSchema;
    }

    private static Schema drop(Schema schema, @Nullable String path, String fullPath) {
        if (path == null) {
            return schema;
        }
        if (schema.getType() != Schema.Type.RECORD) {
            return schema;
        }
        int dotIndex = path.indexOf(46);
        String recordField = dotIndex > 0 ? path.substring(0, dotIndex) : path;
        String nextPath = dotIndex > 0 ? path.substring(dotIndex + 1) : null;
        int arrayIndex = -1;
        int bracketIndex = recordField.indexOf(91);
        if (bracketIndex > 0) {
            if (!recordField.endsWith("]")) {
                throw new IllegalArgumentException(String.format("Invalid field '%s' in path '%s'. An array index start with '[' and must end with a ']'", recordField, fullPath));
            }
            String indexStr = recordField.substring(bracketIndex + 1, recordField.length() - 1);
            try {
                arrayIndex = Integer.parseInt(indexStr);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(String.format("Invalid array index '%s' for field '%s' in path '%s'. Must be a valid integer.", indexStr, recordField, fullPath));
            }
            recordField = recordField.substring(0, bracketIndex);
        }
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (Schema.Field field : schema.getFields()) {
            if (field.getName().equals(recordField)) {
                Schema.Type fieldtype;
                if (nextPath == null) continue;
                Schema fieldSchema = field.getSchema();
                boolean isNullable = fieldSchema.isNullable();
                Schema.Type type = fieldtype = isNullable ? fieldSchema.getNonNullable().getType() : fieldSchema.getType();
                if (arrayIndex >= 0) {
                    Schema.Type componentType;
                    if (fieldtype != Schema.Type.ARRAY) {
                        throw new IllegalArgumentException(String.format("Array syntax for nested field '%s' in path '%s' was specified, but '%s' is of type %s.", recordField, fullPath, recordField, fieldtype));
                    }
                    Schema componentSchema = isNullable ? fieldSchema.getNonNullable().getComponentSchema() : fieldSchema.getComponentSchema();
                    boolean componentNullable = componentSchema.isNullable();
                    Schema.Type type2 = componentType = componentNullable ? componentSchema.getNonNullable().getType() : componentSchema.getType();
                    if (nextPath != null && componentType != Schema.Type.RECORD) {
                        throw new IllegalArgumentException(String.format("Nested field '%s' in path '%s' must be of type '%s', but is '%s'.", recordField, fullPath, Schema.Type.RECORD, componentType));
                    }
                    Schema componentSchemaWithout = DDL.drop(componentNullable ? componentSchema.getNonNullable() : fieldSchema, nextPath, fullPath);
                    componentSchemaWithout = componentNullable ? Schema.nullableOf((Schema)componentSchemaWithout) : componentSchemaWithout;
                    Schema arraySchema = Schema.arrayOf((Schema)componentSchemaWithout);
                    arraySchema = isNullable ? Schema.nullableOf((Schema)arraySchema) : arraySchema;
                    fields.add(Schema.Field.of((String)field.getName(), (Schema)arraySchema));
                    continue;
                }
                if (nextPath != null && fieldtype != Schema.Type.RECORD) {
                    throw new IllegalArgumentException(String.format("Nested field '%s' in path '%s' must be of type '%s', but is '%s'.", recordField, fullPath, Schema.Type.RECORD, fieldtype));
                }
                fields.add(Schema.Field.of((String)field.getName(), (Schema)DDL.drop(field.getSchema(), nextPath, fullPath)));
                continue;
            }
            fields.add(field);
        }
        return Schema.recordOf((String)schema.getRecordName(), fields);
    }

    public static Schema select(Schema schema, String path) {
        return DDL.select(schema, path, Splitter.on((char)'.').split((CharSequence)path).iterator());
    }

    private static Schema select(Schema schema, String path, Iterator<String> fields) {
        Schema.Type fieldType;
        Schema.Field field;
        String fieldName = fields.next();
        String key = null;
        int bracketIndex = fieldName.indexOf(91);
        if (bracketIndex > 0) {
            if (!fieldName.endsWith("]")) {
                throw new IllegalArgumentException(String.format("Invalid field '%s'. An index start '[' must end with a ']'", fieldName));
            }
            key = fieldName.substring(bracketIndex + 1, fieldName.length() - 1);
            fieldName = fieldName.substring(0, bracketIndex);
        }
        if ((field = schema.getField(fieldName)) == null) {
            throw new IllegalArgumentException(String.format("Nested field '%s' in path '%s' does not exist", fieldName, path));
        }
        Schema fieldSchema = field.getSchema();
        boolean isNullable = fieldSchema.isNullable();
        Schema.Type type = fieldType = isNullable ? fieldSchema.getNonNullable().getType() : fieldSchema.getType();
        if (key != null) {
            if (fieldType == Schema.Type.ARRAY) {
                try {
                    int arrayIndex = Integer.parseInt(key);
                    if (arrayIndex < 0) {
                        throw new IllegalArgumentException(String.format("Invalid array index '%d' for field '%s' in path '%s. Must be at least 0.", arrayIndex, fieldName, path));
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Invalid array index '%s' for field '%s' in path '%s'. Must be a valid int.", key, fieldName, path));
                }
                fieldSchema = isNullable ? fieldSchema.getNonNullable().getComponentSchema() : fieldSchema.getComponentSchema();
                isNullable = fieldSchema.isNullable();
                fieldType = isNullable ? fieldSchema.getNonNullable().getType() : fieldSchema.getType();
            } else if (fieldType == Schema.Type.MAP) {
                Schema.Type keyType;
                Map.Entry mapSchema = fieldSchema.getMapSchema();
                Schema keySchema = (Schema)mapSchema.getKey();
                Schema valSchema = (Schema)mapSchema.getValue();
                Schema.Type type2 = keyType = keySchema.isNullable() ? keySchema.getNonNullable().getType() : keySchema.getType();
                if (keyType != Schema.Type.STRING) {
                    throw new IllegalArgumentException(String.format("Only map keys of type string are supported. Field '%s' in path '%s' has keys of type '%s'.", fieldName, path, keyType));
                }
                fieldSchema = valSchema;
                isNullable = fieldSchema.isNullable();
                fieldType = isNullable ? fieldSchema.getNonNullable().getType() : fieldSchema.getType();
            } else {
                throw new IllegalArgumentException(String.format("Array syntax for nested field '%s' in path '%s' was specified, but '%s' is of type %s.", fieldName, path, fieldName, fieldType));
            }
        }
        if (fields.hasNext()) {
            if (fieldType != Schema.Type.RECORD) {
                throw new IllegalArgumentException(String.format("Nested field '%s' in path '%s' must be of type '%s', but is '%s'.", fieldName, path, Schema.Type.RECORD, fieldType));
            }
            return DDL.select(isNullable ? fieldSchema.getNonNullable() : fieldSchema, path, fields);
        }
        return fieldSchema;
    }

    public static StructuredRecord drop(StructuredRecord record, String path) {
        return DDL.drop(record, path, path);
    }

    public static StructuredRecord drop(StructuredRecord record, String path, String ... paths) {
        return record;
    }

    public static <T> T select(StructuredRecord record, String path) {
        return DDL.recursiveGet(record, path, Splitter.on((char)'.').split((CharSequence)path).iterator());
    }

    private static <T> T recursiveGet(StructuredRecord record, String path, Iterator<String> fields) {
        Schema.Field field;
        String fieldName = fields.next();
        int bracketIndex = fieldName.indexOf(91);
        String key = null;
        if (bracketIndex > 0) {
            if (!fieldName.endsWith("]")) {
                throw new IllegalArgumentException(String.format("Invalid field '%s'. An index start '[' must end with a ']'", fieldName));
            }
            key = fieldName.substring(bracketIndex + 1, fieldName.length() - 1);
            fieldName = fieldName.substring(0, bracketIndex);
        }
        if ((field = record.getSchema().getField(fieldName)) == null) {
            throw new IllegalArgumentException(String.format("Nested field '%s' in path '%s' does not exist", fieldName, path));
        }
        Schema fieldSchema = field.getSchema();
        boolean isNullable = fieldSchema.isNullable();
        Schema.Type fieldType = isNullable ? fieldSchema.getNonNullable().getType() : fieldSchema.getType();
        Object val = record.get(fieldName);
        if (key != null) {
            if (fieldType == Schema.Type.ARRAY) {
                try {
                    int arrayIndex = Integer.parseInt(key);
                    if (arrayIndex < 0) {
                        throw new IllegalArgumentException(String.format("Invalid array index '%d' for field '%s' in path '%s. Must be at least 0.", arrayIndex, fieldName, path));
                    }
                    fieldSchema = isNullable ? fieldSchema.getNonNullable().getComponentSchema() : fieldSchema.getComponentSchema();
                    isNullable = fieldSchema.isNullable();
                    fieldType = isNullable ? fieldSchema.getNonNullable().getType() : fieldSchema.getType();
                    try {
                        if (val instanceof Collection) {
                            val = Iterables.get((Iterable)((Collection)val), (int)arrayIndex);
                        }
                        val = Array.get(val, arrayIndex);
                    }
                    catch (IndexOutOfBoundsException e) {
                        throw new IllegalArgumentException(String.format("Index '%d' for nested field '%s' in path '%s' is out of bounds.", arrayIndex, fieldName, path));
                    }
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(String.format("Invalid array index '%s' for field '%s' in path '%s'. Must be a valid int.", key, fieldName, path));
                }
            } else if (fieldType == Schema.Type.MAP) {
                Schema.Type keyType;
                Map.Entry mapSchema = fieldSchema.getMapSchema();
                Schema keySchema = (Schema)mapSchema.getKey();
                Schema valSchema = (Schema)mapSchema.getValue();
                Schema.Type type = keyType = keySchema.isNullable() ? keySchema.getNonNullable().getType() : keySchema.getType();
                if (keyType != Schema.Type.STRING) {
                    throw new IllegalArgumentException(String.format("Only map keys of type string are supported. Field '%s' in path '%s' has keys of type '%s'.", fieldName, path, keyType));
                }
                fieldSchema = valSchema;
                isNullable = fieldSchema.isNullable();
                fieldType = isNullable ? fieldSchema.getNonNullable().getType() : fieldSchema.getType();
                Map map = (Map)val;
                val = map.get(key);
            } else {
                throw new IllegalArgumentException(String.format("Array syntax for nested field '%s' in path '%s' was specified, but '%s' is of type %s.", fieldName, path, fieldName, fieldType));
            }
        }
        if (fields.hasNext()) {
            if (fieldType != Schema.Type.RECORD) {
                throw new IllegalArgumentException(String.format("Nested field '%s' in path '%s' must be of type '%s', but is '%s'.", fieldName, path, Schema.Type.RECORD, fieldType));
            }
            return DDL.recursiveGet((StructuredRecord)val, path, fields);
        }
        return (T)val;
    }
}

