/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

@Plugin(type="directive")
@Name(value="mask-shuffle")
@Categories(categories={"transform"})
@Description(value="Masks a column value by shuffling characters while maintaining the same length.")
public class MaskShuffle
implements Directive,
Lineage {
    public static final String NAME = "mask-shuffle";
    private String column;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            Row masked = new Row(row);
            int idx = row.find(this.column);
            if (idx == -1) {
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' does not exist.", this.column));
            }
            masked.setValue(idx, (Object)this.maskShuffle((String)row.getValue(idx), 0));
            results.add(masked);
        }
        return results;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Masked column '%s' by shuffling the values", new Object[]{this.column}).relation(this.column, this.column).build();
    }

    private String maskShuffle(String str, int seed) {
        String cons = "bcdfghjklmnpqrstvwxz";
        String vowel = "aeiouy";
        String digit = "0123456789";
        Random r = new Random(seed);
        char[] data = str.toCharArray();
        for (int n = 0; n < data.length; ++n) {
            char ln = Character.toLowerCase(data[n]);
            if ("bcdfghjklmnpqrstvwxz".indexOf(ln) >= 0) {
                data[n] = this.randomChar(r, "bcdfghjklmnpqrstvwxz", ln != data[n]);
                continue;
            }
            if ("aeiouy".indexOf(ln) >= 0) {
                data[n] = this.randomChar(r, "aeiouy", ln != data[n]);
                continue;
            }
            if ("0123456789".indexOf(ln) < 0) continue;
            data[n] = this.randomChar(r, "0123456789", ln != data[n]);
        }
        return new String(data);
    }

    private char randomChar(Random r, String cs, boolean uppercase) {
        char c = cs.charAt(r.nextInt(cs.length()));
        return uppercase ? Character.toUpperCase(c) : c;
    }
}

