/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Plugin(type="directive")
@Name(value="extract-regex-groups")
@Categories(categories={"transform"})
@Description(value="Extracts data from a regex group into its own column.")
public class ExtractRegexGroups
implements Directive,
Lineage {
    public static final String NAME = "extract-regex-groups";
    private String column;
    private String regex;
    private Pattern pattern;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("regex", TokenType.TEXT);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.regex = ((Text)args.value("regex")).value();
        this.pattern = Pattern.compile(this.regex);
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            Object value;
            int idx = row.find(this.column);
            if (idx == -1 || (value = row.getValue(idx)) == null || !(value instanceof String)) continue;
            Matcher matcher = this.pattern.matcher((String)value);
            int count = 1;
            while (matcher.find()) {
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    row.add(String.format("%s_%d_%d", this.column, count, i), (Object)matcher.group(i));
                }
                ++count;
            }
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Split column '%s' based on expression '%s' ", new Object[]{this.column, this.regex}).all(Many.of((String[])new String[]{this.column}), Many.of((String[])new String[]{this.column})).build();
    }
}

