/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.row;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Numeric;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.List;

@Plugin(type="directive")
@Name(value="set-record-delim")
@Categories(categories={"row"})
@Description(value="Sets the record delimiter.")
public class SetRecordDelimiter
implements Directive,
Lineage {
    public static final String NAME = "set-record-delim";
    private String column;
    private String delimiter;
    private int limit;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("delimiter", TokenType.TEXT);
        builder.define("limit", TokenType.NUMERIC, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.delimiter = ((Text)args.value("delimiter")).value();
        if (args.contains("limit")) {
            Numeric numeric = (Numeric)args.value("limit");
            this.limit = numeric.value().intValue();
        } else {
            this.limit = Integer.MAX_VALUE;
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException, ErrorRowException {
        ArrayList<Row> results = new ArrayList<Row>();
        block0: for (Row row : rows) {
            Object object;
            int idx = row.find(this.column);
            if (idx == -1 || !((object = row.getValue(idx)) instanceof String)) continue;
            String body = (String)object;
            String[] lines = body.split(this.delimiter);
            int i = 0;
            for (String line : lines) {
                if (i > this.limit) continue block0;
                results.add(new Row(this.column, (Object)line));
                ++i;
            }
        }
        return results;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Split value in column '%s' into multiple records using delimiter '%s'", new Object[]{this.column, this.delimiter}).relation(this.column, this.column).build();
    }
}

