/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.parser;

import ca.uhn.hl7v2.DefaultHapiContext;
import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.Field;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.MessageVisitor;
import ca.uhn.hl7v2.model.MessageVisitors;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Visitable;
import ca.uhn.hl7v2.parser.GenericModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import ca.uhn.hl7v2.parser.Parser;
import ca.uhn.hl7v2.parser.PipeParser;
import ca.uhn.hl7v2.validation.ValidationContext;
import ca.uhn.hl7v2.validation.impl.NoValidation;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.directives.parser.JsParser;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Numeric;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;

@Plugin(type="directive")
@Name(value="parse-as-hl7")
@Categories(categories={"parser", "hl7"})
@Description(value="Parses <column> for Health Level 7 Version 2 (HL7 V2) messages; <depth> indicates at which point JSON object enumeration terminates.")
public class HL7Parser
implements Directive,
Lineage {
    public static final String NAME = "parse-as-hl7";
    private String column;
    private HapiContext context;
    private Parser parser;
    private int depth;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("depth", TokenType.NUMERIC, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.depth = args.contains("depth") ? ((Numeric)args.value("depth")).value().intValue() : Integer.MAX_VALUE;
        this.context = new DefaultHapiContext();
        this.context.setValidationContext((ValidationContext)new NoValidation());
        GenericModelClassFactory modelClassFactory = new GenericModelClassFactory();
        this.parser = new PipeParser((ModelClassFactory)modelClassFactory);
        this.parser.getParserConfiguration().setAllowUnknownVersions(true);
    }

    public void destroy() {
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Parsed column '%s' as HL7 record", new Object[]{this.column}).all(Many.columns((String[])new String[]{this.column}), Many.columns((String[])new String[]{this.column})).build();
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            try {
                int idx = row.find(this.column);
                if (idx == -1) continue;
                Object object = row.getValue(idx);
                if (object == null) {
                    throw new DirectiveExecutionException(NAME, String.format("Column '%s' has null value. It should be a non-null 'String'.", this.column));
                }
                if (object instanceof String) {
                    Message message = this.parser.parse((String)object);
                    HL7MessageVisitor visitor = new HL7MessageVisitor(row, this.column + "_hl7", this.depth);
                    ((MessageVisitors.PopulatedVisitor)MessageVisitors.visit((Visitable)message, (MessageVisitor)MessageVisitors.visitPopulatedElements((MessageVisitor)visitor))).getDelegate();
                    continue;
                }
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' has invalid type '%s'. It should be of type 'String'.", this.column, object.getClass().getSimpleName()));
            }
            catch (HL7Exception e) {
                throw new DirectiveExecutionException(NAME, e.getMessage(), (Throwable)e);
            }
        }
        return rows;
    }

    private final class HL7MessageVisitor
    implements MessageVisitor {
        private final Row row;
        private final String column;
        private final int depth;
        private JsonObject segments = new JsonObject();
        private JsonObject segmentObject = new JsonObject();
        private JsonObject compositeObject = new JsonObject();
        private boolean inComposite = false;

        HL7MessageVisitor(Row row, String column, int depth) {
            this.row = row;
            this.column = column;
            this.depth = depth;
        }

        public boolean start(Message message) {
            return true;
        }

        public boolean end(Message message) {
            JsParser.jsonFlatten(this.segments, this.column, 1, this.depth, this.row);
            return true;
        }

        public boolean start(Group group, Location location) {
            return true;
        }

        public boolean end(Group group, Location location) {
            return true;
        }

        public boolean start(Segment segment, Location location) {
            this.segmentObject = new JsonObject();
            return true;
        }

        public boolean end(Segment segment, Location location) {
            if (!this.segments.has(segment.getName())) {
                this.segments.add(segment.getName(), (JsonElement)this.segmentObject);
            } else {
                JsonElement object = this.segments.get(segment.getName());
                if (!(object instanceof JsonArray)) {
                    JsonObject o = (JsonObject)this.segments.get(segment.getName());
                    JsonArray a = new JsonArray();
                    a.add((JsonElement)o);
                    a.add((JsonElement)this.segmentObject);
                    this.segments.add(segment.getName(), (JsonElement)a);
                }
            }
            return true;
        }

        public boolean start(Field field, Location location) {
            return true;
        }

        public boolean end(Field field, Location location) {
            return true;
        }

        public boolean start(Composite composite, Location location) {
            this.inComposite = true;
            this.compositeObject = new JsonObject();
            return true;
        }

        public boolean end(Composite composite, Location location) {
            this.segmentObject.add(Integer.toString(location.getField()), (JsonElement)this.compositeObject);
            this.inComposite = false;
            return true;
        }

        public boolean visit(Primitive primitive, Location location) {
            if (this.inComposite) {
                this.compositeObject.addProperty(Integer.toString(location.getComponent()), primitive.getValue());
            } else {
                String fieldComponent = String.format("%d_%d", location.getField(), location.getComponent());
                if (location.getComponent() < 0) {
                    fieldComponent = String.format("%d", location.getField());
                }
                this.segmentObject.addProperty(fieldComponent, primitive.getValue());
            }
            return true;
        }
    }
}

