/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.parser;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.Bool;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.dq.DataType;
import io.cdap.wrangler.dq.TypeInference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang3.StringEscapeUtils;

@Plugin(type="directive")
@Name(value="parse-as-csv")
@Categories(categories={"parser", "csv"})
@Description(value="Parses a column as CSV (comma-separated values).")
public class CsvParser
implements Directive,
Lineage {
    public static final String NAME = "parse-as-csv";
    private ColumnName columnArg;
    private Text delimiterArg;
    private Bool headerArg;
    private CSVFormat format;
    private boolean hasHeader;
    private boolean checkedHeader = false;
    private List<String> headers = new ArrayList<String>();

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("col", TokenType.COLUMN_NAME);
        builder.define("delimiter", TokenType.TEXT, true);
        builder.define("header", TokenType.BOOLEAN, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.columnArg = (ColumnName)args.value("col");
        char delimiter = ',';
        if (args.contains("delimiter")) {
            this.delimiterArg = (Text)args.value("delimiter");
            delimiter = this.delimiterArg.value().charAt(0);
            if (this.delimiterArg.value().startsWith("\\")) {
                String unescapedStr = StringEscapeUtils.unescapeJava((String)this.delimiterArg.value());
                if (unescapedStr == null) {
                    throw new DirectiveParseException(NAME, String.format("Invalid delimiter for CSV Parser '%s'", this.delimiterArg.value()));
                }
                delimiter = unescapedStr.charAt(0);
            }
        }
        this.format = CSVFormat.DEFAULT.withDelimiter(delimiter);
        this.format.withIgnoreEmptyLines(true).withAllowMissingColumnNames(true).withIgnoreSurroundingSpaces(true).withRecordSeparator('\n');
        this.hasHeader = false;
        if (args.contains("header")) {
            this.headerArg = (Bool)args.value("header");
            this.hasHeader = this.headerArg.value();
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException, ErrorRowException {
        for (Row row : rows) {
            String line;
            int idx = row.find(this.columnArg.value());
            if (idx == -1 || (line = (String)row.getValue(idx)) == null || line.isEmpty()) continue;
            CSVParser parser = null;
            try {
                parser = CSVParser.parse((String)line, (CSVFormat)this.format);
                List csvRecords = parser.getRecords();
                for (CSVRecord csvRecord : csvRecords) {
                    if (!this.checkedHeader && this.hasHeader && this.isHeader(csvRecord)) {
                        for (int i = 0; i < csvRecord.size(); ++i) {
                            this.headers.add(csvRecord.get(i).trim().replaceAll("\\s+", "_"));
                        }
                        if (rows.size() <= 0) continue;
                        return new ArrayList<Row>();
                    }
                    this.toRow(csvRecord, row);
                }
            }
            catch (IOException e) {
                throw new ErrorRowException(NAME, e.getMessage(), 1);
            }
        }
        return rows;
    }

    private void toRow(CSVRecord record, Row row) {
        int size = this.headers.size();
        for (int i = 0; i < record.size(); ++i) {
            if (size > 0) {
                row.add(this.headers.get(i), (Object)record.get(i));
                continue;
            }
            row.add(this.columnArg.value() + "_" + (i + 1), (Object)record.get(i));
        }
    }

    private boolean isHeader(CSVRecord record) {
        this.checkedHeader = true;
        HashSet<String> columns = new HashSet<String>();
        for (int i = 0; i < record.size(); ++i) {
            String value = record.get(i);
            if (value == null || value.trim().isEmpty()) {
                return false;
            }
            DataType type = TypeInference.getDataType(value);
            if (type != DataType.STRING) {
                return false;
            }
            if (columns.contains(value)) {
                return false;
            }
            columns.add(value);
        }
        return true;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Parsed column '%s' as CSV with delimiter '%s'", new Object[]{this.columnArg.value(), this.delimiterArg.value()}).all(Many.columns((ColumnName[])new ColumnName[]{this.columnArg}), Many.columns((ColumnName[])new ColumnName[]{this.columnArg})).build();
    }
}

