/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.language;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;

@Plugin(type="directive")
@Name(value="set-charset")
@Categories(categories={"language"})
@Description(value="Sets the character set decoding to UTF-8.")
public class SetCharset
implements Directive,
Lineage {
    public static final String NAME = "set-charset";
    private String column;
    private String charset;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("charset", TokenType.TEXT);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.charset = ((Text)args.value("charset")).value();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException, ErrorRowException {
        for (Row row : rows) {
            ByteBuffer buffer;
            Object object;
            int idx = row.find(this.column);
            if (idx == -1 || (object = row.getValue(idx)) == null) continue;
            if (object instanceof byte[]) {
                buffer = ByteBuffer.wrap((byte[])object);
            } else if (object instanceof ByteBuffer) {
                buffer = (ByteBuffer)object;
            } else {
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' is of invalid type '%s'. It should be of type 'byte array' or 'ByteBuffer'.", this.column, object.getClass().getSimpleName()));
            }
            try {
                CharBuffer result = Charset.forName(this.charset).decode(buffer);
                row.setValue(idx, (Object)result.toString());
            }
            catch (Error e) {
                throw new DirectiveExecutionException(NAME, String.format("Can not convert to character set '%s', %s", this.charset, e.getMessage()), (Throwable)e);
            }
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Changed character set of column '%s' to '%s'", new Object[]{this.column, this.charset}).relation(this.column, this.column).build();
    }
}

