/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.datetime;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.List;

@Plugin(type="directive")
@Name(value="timestamp-to-datetime")
@Categories(categories={"datetime"})
@Description(value="Convert a timestamp column to datetime")
public class TimestampToDateTime
implements Directive,
Lineage {
    public static final String NAME = "timestamp-to-datetime";
    private static final String COLUMN = "column";
    private String column;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define(COLUMN, TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) {
        this.column = ((ColumnName)args.value(COLUMN)).value();
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws ErrorRowException {
        for (Row row : rows) {
            Object value;
            int idx = row.find(this.column);
            if (idx == -1 || (value = row.getValue(idx)) == null || value instanceof LocalDateTime) continue;
            if (!(value instanceof ZonedDateTime)) {
                throw new ErrorRowException(NAME, String.format("Value %s for column %s expected to be timestamp but found %s", value.toString(), this.column, value.getClass().getSimpleName()), 2);
            }
            ZonedDateTime timestamp = (ZonedDateTime)value;
            row.setValue(idx, (Object)timestamp.toLocalDateTime());
        }
        return rows;
    }

    public void destroy() {
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Converted column '%s' from timestamp to datetime", new Object[]{this.column}).relation(this.column, this.column).build();
    }
}

