/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.datetime;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

@Plugin(type="directive")
@Name(value="format-datetime")
@Categories(categories={"format", "datetime"})
@Description(value="Formats a datetime value to a string using the given format")
public class FormatDateTime
implements Directive,
Lineage {
    public static final String NAME = "format-datetime";
    private static final String COLUMN = "column";
    private static final String FORMAT = "format";
    private String column;
    private String format;
    private DateTimeFormatter formatter;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define(COLUMN, TokenType.COLUMN_NAME);
        builder.define(FORMAT, TokenType.TEXT, false);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value(COLUMN)).value();
        this.format = args.value(FORMAT).value().toString();
        try {
            this.formatter = DateTimeFormatter.ofPattern(this.format);
        }
        catch (IllegalArgumentException exception) {
            throw new DirectiveParseException(NAME, String.format("Datetime format '%s' is invalid.", this.format), (Throwable)exception);
        }
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws ErrorRowException {
        for (Row row : rows) {
            Object value;
            int idx = row.find(this.column);
            if (idx == -1 || (value = row.getValue(idx)) == null) continue;
            if (!(value instanceof LocalDateTime)) {
                throw new ErrorRowException(NAME, String.format("Value %s for column %s expected to be datetime but found %s", value.toString(), this.column, value.getClass().getSimpleName()), 2);
            }
            try {
                LocalDateTime localDateTime = (LocalDateTime)value;
                row.setValue(idx, (Object)localDateTime.format(this.formatter));
            }
            catch (DateTimeException exception) {
                throw new ErrorRowException(NAME, String.format("Error converting datetime %s to string with format %s", value.toString(), this.format), 2, (Throwable)exception);
            }
        }
        return rows;
    }

    public void destroy() {
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Datetime column '%s' converted to string with format '%s'", new Object[]{this.column, this.format}).relation(this.column, this.column).build();
    }
}

