/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.datetime;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.zone.ZoneRulesException;
import java.util.List;

@Plugin(type="directive")
@Name(value="datetime-to-timestamp")
@Categories(categories={"datetime"})
@Description(value="Converts a datetime column to timestamp")
public class DateTimeToTimeStamp
implements Directive,
Lineage {
    public static final String NAME = "datetime-to-timestamp";
    private static final String COLUMN = "column";
    private static final String ZONE = "timezone";
    private String column;
    private String zone;
    private ZoneId zoneId;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define(COLUMN, TokenType.COLUMN_NAME);
        builder.define(ZONE, TokenType.TEXT, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value(COLUMN)).value();
        if (args.value(ZONE) == null) {
            this.zoneId = ZoneId.of("UTC");
            this.zone = this.zoneId.toString();
            return;
        }
        this.zone = args.value(ZONE).value().toString();
        try {
            this.zoneId = ZoneId.of(this.zone);
        }
        catch (IllegalArgumentException | ZoneRulesException exception) {
            throw new DirectiveParseException(NAME, String.format("Zone '%s' is invalid.", this.zone), (Throwable)exception);
        }
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws ErrorRowException {
        for (Row row : rows) {
            Object value;
            int idx = row.find(this.column);
            if (idx == -1 || (value = row.getValue(idx)) == null) continue;
            if (!(value instanceof LocalDateTime)) {
                throw new ErrorRowException(NAME, String.format("Value %s for column %s expected to be datetime but found %s", value.toString(), this.column, value.getClass().getSimpleName()), 2);
            }
            ZonedDateTime zonedDateTime = ZonedDateTime.of((LocalDateTime)value, this.zoneId);
            row.setValue(idx, (Object)zonedDateTime);
        }
        return rows;
    }

    public void destroy() {
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Datetime column '%s' converted to timestamp with zone '%s'", new Object[]{this.column, this.zone}).relation(this.column, this.column).build();
    }
}

