/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.currency;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;

@Plugin(type="directive")
@Name(value="parse-as-currency")
@Categories(categories={"currency"})
@Description(value="Parses the string as a currency using specified locale. Default locale is en_US.")
public class ParseAsCurrency
implements Directive,
Lineage {
    public static final String NAME = "parse-as-currency";
    private String source;
    private String destination;
    private String locale;
    private NumberFormat fmt;
    private Locale lcl;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("source", TokenType.COLUMN_NAME);
        builder.define("destination", TokenType.COLUMN_NAME);
        builder.define("locale", TokenType.TEXT, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.source = ((ColumnName)args.value("source")).value();
        this.destination = ((ColumnName)args.value("destination")).value();
        this.locale = args.contains("locale") ? ((Text)args.value("locale")).value() : "en_US";
        this.lcl = LocaleUtils.toLocale((String)this.locale);
        this.fmt = NumberFormat.getCurrencyInstance(this.lcl);
        ((DecimalFormat)this.fmt).setParseBigDecimal(true);
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException, ErrorRowException {
        for (Row row : rows) {
            String value;
            Object object;
            int idx = row.find(this.source);
            if (idx == -1 || (object = row.getValue(idx)) == null || !(object instanceof String) || (value = (String)object).trim().isEmpty()) continue;
            try {
                BigDecimal number = (BigDecimal)this.fmt.parse(value);
                row.addOrSet(this.destination, (Object)number.doubleValue());
            }
            catch (ParseException e) {
                throw new ErrorRowException(NAME, e.getMessage(), 1);
            }
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Parsed column '%s' as locale currency '%s' into column '%s'", new Object[]{this.source, this.locale, this.destination}).conditional(this.source, this.destination).build();
    }
}

