/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.column;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Identifier;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.utils.ColumnConverter;
import java.util.List;

@Plugin(type="directives")
@Name(value="set-type")
@Categories(categories={"column"})
@Description(value="Converting data type of a column.")
public final class SetType
implements Directive,
Lineage {
    public static final String NAME = "set-type";
    private String col;
    private String type;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("type", TokenType.IDENTIFIER);
        return builder.build();
    }

    public void initialize(Arguments args) {
        this.col = ((ColumnName)args.value("column")).value();
        this.type = ((Identifier)args.value("type")).value();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            ColumnConverter.convertType(NAME, row, this.col, this.type);
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Changed the column '%s' to type '%s'", new Object[]{this.col, this.type}).relation(this.col, this.col).build();
    }
}

