/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import com.google.common.collect.ImmutableMap;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class StructuredRecordJsonConverter {
    private static final Map<Class<?>, Schema.Type> TYPE_TO_SCHEMA = new IdentityHashMap((Map<Class<?>, Schema.Type>)ImmutableMap.builder().put(Boolean.class, (Object)Schema.Type.BOOLEAN).put(Byte.class, (Object)Schema.Type.INT).put(Short.class, (Object)Schema.Type.INT).put(Integer.class, (Object)Schema.Type.INT).put(Long.class, (Object)Schema.Type.LONG).put(Float.class, (Object)Schema.Type.FLOAT).put(Double.class, (Object)Schema.Type.DOUBLE).put(String.class, (Object)Schema.Type.STRING).put(ByteBuffer.class, (Object)Schema.Type.BYTES).put(byte[].class, (Object)Schema.Type.BYTES).put(StructuredRecord.class, (Object)Schema.Type.RECORD).build());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String toJsonString(StructuredRecord record) throws IOException {
        StringWriter strWriter = new StringWriter();
        try (JsonWriter writer = new JsonWriter((Writer)strWriter);){
            StructuredRecordJsonConverter.writeJson(writer, record.getSchema(), record);
            String string = strWriter.toString();
            return string;
        }
    }

    private static Object readJson(JsonReader reader, Schema schema) throws IOException {
        switch (schema.getType()) {
            case NULL: {
                reader.nextNull();
                return null;
            }
            case BOOLEAN: {
                return reader.nextBoolean();
            }
            case INT: {
                return reader.nextInt();
            }
            case LONG: {
                return reader.nextLong();
            }
            case FLOAT: {
                return Float.valueOf((float)reader.nextDouble());
            }
            case DOUBLE: {
                return reader.nextDouble();
            }
            case BYTES: {
                return StructuredRecordJsonConverter.readBytes(reader);
            }
            case STRING: {
                return reader.nextString();
            }
            case ENUM: {
                return reader.nextString();
            }
            case ARRAY: {
                return StructuredRecordJsonConverter.readArray(reader, schema.getComponentSchema());
            }
            case MAP: {
                return StructuredRecordJsonConverter.readMap(reader, schema.getMapSchema());
            }
            case RECORD: {
                return StructuredRecordJsonConverter.readRecord(reader, schema);
            }
            case UNION: {
                return StructuredRecordJsonConverter.readUnion(reader, schema);
            }
        }
        throw new IOException("Unsupported schema: " + schema);
    }

    private static byte[] readBytes(JsonReader reader) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream(128);
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            os.write(reader.nextInt());
        }
        reader.endArray();
        return os.toByteArray();
    }

    private static List<Object> readArray(JsonReader reader, Schema elementSchema) throws IOException {
        ArrayList<Object> result = new ArrayList<Object>();
        reader.beginArray();
        while (reader.peek() != JsonToken.END_ARRAY) {
            result.add(StructuredRecordJsonConverter.readJson(reader, elementSchema));
        }
        reader.endArray();
        return result;
    }

    private static Map<Object, Object> readMap(JsonReader reader, Map.Entry<Schema, Schema> mapSchema) throws IOException {
        Schema keySchema = mapSchema.getKey();
        if (!keySchema.isCompatible(Schema.of((Schema.Type)Schema.Type.STRING))) {
            throw new IOException("Complex key type not supported: " + keySchema);
        }
        Schema valueSchema = mapSchema.getValue();
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        reader.beginObject();
        while (reader.peek() != JsonToken.END_OBJECT) {
            Object key = StructuredRecordJsonConverter.convertKey(reader.nextName(), keySchema.getType());
            result.put(key, StructuredRecordJsonConverter.readJson(reader, valueSchema));
        }
        reader.endObject();
        return result;
    }

    private static Object convertKey(String key, Schema.Type type) throws IOException {
        switch (type) {
            case STRING: {
                return key;
            }
            case BOOLEAN: {
                return Boolean.valueOf(key);
            }
            case INT: {
                return Integer.valueOf(key);
            }
            case LONG: {
                return Long.valueOf(key);
            }
            case FLOAT: {
                return Float.valueOf(key);
            }
            case DOUBLE: {
                return Double.valueOf(key);
            }
        }
        throw new IOException("Unable to convert string to type " + type);
    }

    private static StructuredRecord readRecord(JsonReader reader, Schema schema) throws IOException {
        StructuredRecord.Builder builder = StructuredRecord.builder((Schema)schema);
        reader.beginObject();
        while (reader.peek() != JsonToken.END_OBJECT) {
            Schema.Field field = schema.getField(reader.nextName());
            if (field == null) {
                reader.skipValue();
                continue;
            }
            builder.set(field.getName(), StructuredRecordJsonConverter.readJson(reader, field.getSchema()));
        }
        reader.endObject();
        return builder.build();
    }

    private static Object readUnion(JsonReader reader, Schema unionSchema) throws IOException {
        JsonToken token = reader.peek();
        if (token == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        reader.beginObject();
        String type = reader.nextName();
        Schema matchingSchema = null;
        for (Schema schema : unionSchema.getUnionSchemas()) {
            if (!schema.getType().name().toLowerCase().equals(type) && (schema.getType() != Schema.Type.RECORD || !schema.getRecordName().equals(type))) continue;
            matchingSchema = schema;
            break;
        }
        if (matchingSchema == null) {
            throw new IOException("No matching schema found for type " + type + " in union types: " + unionSchema);
        }
        Object object = StructuredRecordJsonConverter.readJson(reader, matchingSchema);
        reader.endObject();
        return object;
    }

    private static void writeJson(JsonWriter writer, Schema schema, Object value) throws IOException {
        switch (schema.getType()) {
            case NULL: {
                writer.nullValue();
                break;
            }
            case BOOLEAN: {
                writer.value(((Boolean)value).booleanValue());
                break;
            }
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                writer.value((Number)value);
                break;
            }
            case BYTES: {
                StructuredRecordJsonConverter.writeBytes(writer, value);
                break;
            }
            case STRING: {
                writer.value((String)value);
                break;
            }
            case ENUM: {
                writer.value(((Enum)value).name());
                break;
            }
            case ARRAY: {
                StructuredRecordJsonConverter.writeArray(writer, schema.getComponentSchema(), value);
                break;
            }
            case MAP: {
                StructuredRecordJsonConverter.writeMap(writer, schema.getMapSchema(), value);
                break;
            }
            case RECORD: {
                StructuredRecordJsonConverter.writeRecord(writer, schema, value);
                break;
            }
            case UNION: {
                StructuredRecordJsonConverter.writeUnion(writer, schema, value);
            }
        }
    }

    private static void writeUnion(JsonWriter writer, Schema schema, Object value) throws IOException {
        Schema actualSchema = StructuredRecordJsonConverter.findUnionSchema(schema, value);
        Schema.Type type = actualSchema.getType();
        if (type == Schema.Type.NULL) {
            writer.nullValue();
            return;
        }
        writer.beginObject();
        if (type == Schema.Type.RECORD) {
            writer.name(actualSchema.getRecordName());
        } else {
            writer.name(type.name().toLowerCase());
        }
        StructuredRecordJsonConverter.writeJson(writer, actualSchema, value);
        writer.endObject();
    }

    private static void writeBytes(JsonWriter writer, Object value) throws IOException {
        if (value instanceof ByteBuffer) {
            StructuredRecordJsonConverter.writeBytes(writer, (ByteBuffer)value);
        } else if (value.getClass().isArray() && value.getClass().getComponentType().equals(Byte.TYPE)) {
            byte[] bytes = (byte[])value;
            StructuredRecordJsonConverter.writeBytes(writer, bytes, 0, bytes.length);
        } else {
            throw new IOException("Expects either ByteBuffer or byte[]. Got " + value.getClass());
        }
    }

    private static void writeBytes(JsonWriter writer, ByteBuffer buffer) throws IOException {
        if (buffer.hasArray()) {
            StructuredRecordJsonConverter.writeBytes(writer, buffer.array(), buffer.arrayOffset() + buffer.position(), buffer.remaining());
        } else {
            byte[] buf = Bytes.getBytes((ByteBuffer)buffer);
            buffer.mark();
            buffer.get(buf);
            buffer.reset();
            StructuredRecordJsonConverter.writeBytes(writer, buf, 0, buf.length);
        }
    }

    private static void writeBytes(JsonWriter writer, byte[] bytes, int off, int len) throws IOException {
        writer.beginArray();
        for (int i = off; i < off + len; ++i) {
            writer.value((long)bytes[i]);
        }
        writer.endArray();
    }

    private static void writeArray(JsonWriter writer, Schema elementSchema, Object value) throws IOException {
        if (!(value instanceof Collection) && !value.getClass().isArray()) {
            throw new IOException("Expects either Collection or array. Got: " + value.getClass());
        }
        writer.beginArray();
        if (value instanceof Collection) {
            for (Object element : (Collection)value) {
                StructuredRecordJsonConverter.writeJson(writer, elementSchema, element);
            }
        } else {
            for (int i = 0; i < Array.getLength(value); ++i) {
                StructuredRecordJsonConverter.writeJson(writer, elementSchema, Array.get(value, i));
            }
        }
        writer.endArray();
    }

    private static void writeMap(JsonWriter writer, Map.Entry<Schema, Schema> entrySchema, Object value) throws IOException {
        if (!(value instanceof Map)) {
            throw new IOException("Expects a map, have " + value.getClass());
        }
        Schema keySchema = entrySchema.getKey();
        if (!keySchema.isCompatible(Schema.of((Schema.Type)Schema.Type.STRING))) {
            throw new IOException("Complex key type not supported: " + keySchema);
        }
        Schema valueSchema = entrySchema.getValue();
        writer.beginObject();
        for (Map.Entry entry : ((Map)value).entrySet()) {
            writer.name(entry.getKey().toString());
            StructuredRecordJsonConverter.writeJson(writer, valueSchema, entry.getValue());
        }
        writer.endObject();
    }

    private static void writeRecord(JsonWriter writer, Schema schema, Object value) throws IOException {
        if (!(value instanceof StructuredRecord)) {
            throw new IOException("Expects a record, but have " + value.getClass());
        }
        StructuredRecord record = (StructuredRecord)value;
        writer.beginObject();
        for (Schema.Field field : schema.getFields()) {
            Object fieldValue = record.get(field.getName());
            if (fieldValue == null) continue;
            writer.name(field.getName());
            StructuredRecordJsonConverter.writeJson(writer, field.getSchema(), fieldValue);
        }
        writer.endObject();
    }

    private static Schema findUnionSchema(Schema unionSchema, @Nullable Object value) throws IOException {
        Schema.Type type = StructuredRecordJsonConverter.getSchemaType(value);
        for (Schema schema : unionSchema.getUnionSchemas()) {
            if (schema.getType() != type) continue;
            return schema;
        }
        throw new IOException("Value type " + type + " not valid in union: " + unionSchema);
    }

    private static Schema.Type getSchemaType(@Nullable Object value) throws IOException {
        if (value == null) {
            return Schema.Type.NULL;
        }
        Class<?> cls = value.getClass();
        Schema.Type type = TYPE_TO_SCHEMA.get(cls);
        if (type != null) {
            return type;
        }
        if (Collection.class.isAssignableFrom(cls) || cls.isArray()) {
            return Schema.Type.ARRAY;
        }
        if (Map.class.isAssignableFrom(cls)) {
            return Schema.Type.MAP;
        }
        throw new IOException("Unsupported type found in the record: " + cls);
    }

    private StructuredRecordJsonConverter() {
    }
}

