/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.cdap.api.data.schema.UnsupportedTypeException;
import io.cdap.cdap.internal.guava.reflect.TypeToken;
import io.cdap.cdap.internal.io.AbstractSchemaGenerator;
import io.cdap.directives.parser.JsParser;
import io.cdap.wrangler.api.Pair;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.utils.RecordConvertorException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class Json2Schema {
    private final JsonParser parser = new JsonParser();

    public Schema toSchema(String id, Row row) throws RecordConvertorException {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (Pair column : row.getFields()) {
            String name = (String)column.getFirst();
            Object value = column.getSecond();
            if (value instanceof Schema) {
                fields.addAll(((Schema)value).getFields());
                continue;
            }
            Schema schema = this.getSchema(value, name);
            if (schema == null) continue;
            fields.add(Schema.Field.of((String)name, (Schema)schema));
        }
        return Schema.recordOf((String)id, fields);
    }

    @Nullable
    private Schema getSchema(Object value, String name) throws RecordConvertorException {
        if (value instanceof String || value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Double || value instanceof Float || value instanceof Boolean || value instanceof byte[] || value instanceof ByteBuffer) {
            try {
                return Schema.nullableOf((Schema)new SimpleSchemaGenerator().generate(value.getClass()));
            }
            catch (UnsupportedTypeException e) {
                throw new RecordConvertorException(String.format("Unable to convert field '%s' to basic type.", name), e);
            }
        }
        if (value instanceof BigDecimal) {
            return Schema.nullableOf((Schema)Schema.decimalOf((int)38, (int)((BigDecimal)value).scale()));
        }
        if (value instanceof LocalDate) {
            return Schema.nullableOf((Schema)Schema.of((Schema.LogicalType)Schema.LogicalType.DATE));
        }
        if (value instanceof LocalTime) {
            return Schema.nullableOf((Schema)Schema.of((Schema.LogicalType)Schema.LogicalType.TIME_MICROS));
        }
        if (value instanceof ZonedDateTime) {
            return Schema.nullableOf((Schema)Schema.of((Schema.LogicalType)Schema.LogicalType.TIMESTAMP_MICROS));
        }
        if (value instanceof java.util.Date || value instanceof Date || value instanceof Time || value instanceof Timestamp) {
            return Schema.nullableOf((Schema)Schema.of((Schema.Type)Schema.Type.LONG));
        }
        if (value instanceof Map) {
            return Schema.nullableOf((Schema)Schema.mapOf((Schema)Schema.of((Schema.Type)Schema.Type.STRING), (Schema)Schema.of((Schema.Type)Schema.Type.STRING)));
        }
        if (value instanceof JsonElement) {
            return this.toSchema(name, (JsonElement)value);
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object listObject : collection) {
                if (listObject == null) continue;
                Schema schema = this.getSchema(listObject, name);
                if (schema == null) {
                    return null;
                }
                return Schema.nullableOf((Schema)Schema.arrayOf((Schema)schema));
            }
        }
        return null;
    }

    @Nullable
    private Schema toSchema(String name, JsonElement element) throws RecordConvertorException {
        Schema schema = null;
        if (element == null) {
            return null;
        }
        if (element.isJsonObject() || element.isJsonArray()) {
            schema = this.toComplexSchema(name, element);
        } else if (element.isJsonPrimitive()) {
            schema = this.toSchema(name, element.getAsJsonPrimitive());
        } else if (element.isJsonNull()) {
            schema = Schema.of((Schema.Type)Schema.Type.NULL);
        }
        return schema;
    }

    private Schema toSchema(String name, JsonArray array) throws RecordConvertorException {
        int[] types = new int[3];
        types[2] = 0;
        types[1] = 0;
        types[0] = 0;
        for (int i = 0; i < array.size(); ++i) {
            JsonElement item = array.get(i);
            if (item.isJsonArray()) {
                types[1] = types[1] + 1;
                continue;
            }
            if (item.isJsonPrimitive()) {
                types[0] = types[0] + 1;
                continue;
            }
            if (!item.isJsonObject()) continue;
            types[2] = types[2] + 1;
        }
        int sum = types[0] + types[1] + types[2];
        if (sum > 0) {
            JsonElement child = array.get(0);
            if (types[2] > 0 || types[1] > 0) {
                return Schema.nullableOf((Schema)Schema.arrayOf((Schema)this.toComplexSchema(name, child)));
            }
            if (types[0] > 0) {
                return Schema.nullableOf((Schema)Schema.arrayOf((Schema)this.toSchema(name, child.getAsJsonPrimitive())));
            }
        }
        return Schema.nullableOf((Schema)Schema.arrayOf((Schema)Schema.of((Schema.Type)Schema.Type.NULL)));
    }

    private Schema toSchema(String name, JsonPrimitive primitive) throws RecordConvertorException {
        Object value = JsParser.getValue(primitive);
        try {
            return Schema.nullableOf((Schema)new SimpleSchemaGenerator().generate(value.getClass()));
        }
        catch (UnsupportedTypeException e) {
            throw new RecordConvertorException(String.format("Unable to convert field '%s' to basic type.", name), e);
        }
    }

    private Schema toSchema(String name, JsonObject object) throws RecordConvertorException {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        for (Map.Entry next : object.entrySet()) {
            String key = (String)next.getKey();
            JsonElement child = (JsonElement)next.getValue();
            Schema schema = null;
            if (child.isJsonObject() || child.isJsonArray()) {
                schema = this.toComplexSchema(key, child);
            } else if (child.isJsonPrimitive()) {
                schema = this.toSchema(key, child.getAsJsonPrimitive());
            }
            if (schema == null) continue;
            fields.add(Schema.Field.of((String)key, (Schema)schema));
        }
        if (fields.size() == 0) {
            return Schema.nullableOf((Schema)Schema.arrayOf((Schema)Schema.of((Schema.Type)Schema.Type.NULL)));
        }
        return Schema.recordOf((String)name, fields);
    }

    private Schema toComplexSchema(String name, JsonElement element) throws RecordConvertorException {
        if (element.isJsonObject()) {
            return this.toSchema(name, element.getAsJsonObject());
        }
        if (element.isJsonArray()) {
            return this.toSchema(name, element.getAsJsonArray());
        }
        if (element.isJsonPrimitive()) {
            return this.toSchema(name, element.getAsJsonPrimitive());
        }
        return null;
    }

    private static final class SimpleSchemaGenerator
    extends AbstractSchemaGenerator {
        private SimpleSchemaGenerator() {
        }

        protected Schema generateRecord(TypeToken<?> typeToken, Set<String> set, boolean b) throws UnsupportedTypeException {
            throw new UnsupportedTypeException(String.format("Generating record of type %s is not supported.", typeToken));
        }
    }
}

