/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import io.cdap.cdap.api.common.Bytes;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.Row;

public final class ColumnConverter {
    private ColumnConverter() {
    }

    public static void rename(String directiveName, Row row, String column, String toName) throws DirectiveExecutionException {
        int idx = row.find(column);
        int existingColumn = row.find(toName);
        if (idx != -1) {
            if (existingColumn == -1) {
                row.setColumn(idx, toName);
            } else {
                throw new DirectiveExecutionException(directiveName, String.format("Column '%s' already exists. Apply the 'drop %s' directive before renaming '%s' to '%s'.", toName, toName, column, toName));
            }
        }
    }

    public static void convertType(String directiveName, Row row, String column, String toType) throws DirectiveExecutionException {
        int idx = row.find(column);
        if (idx != -1) {
            Object object = row.getValue(idx);
            if (object == null || object instanceof String && ((String)object).trim().isEmpty()) {
                return;
            }
            try {
                row.setValue(idx, ColumnConverter.convertType(column, toType, object));
            }
            catch (DirectiveExecutionException e) {
                throw e;
            }
            catch (Exception e) {
                throw new DirectiveExecutionException(directiveName, String.format("Column '%s' cannot be converted to a '%s'.", column, toType), (Throwable)e);
            }
        }
    }

    private static Object convertType(String col, String toType, Object object) throws Exception {
        switch (toType = toType.toUpperCase()) {
            case "INTEGER": 
            case "I64": 
            case "INT": {
                if (object instanceof String) {
                    return Integer.parseInt((String)object);
                }
                if (object instanceof Short) {
                    return ((Short)object).intValue();
                }
                if (object instanceof Float) {
                    return ((Float)object).intValue();
                }
                if (object instanceof Double) {
                    return ((Double)object).intValue();
                }
                if (object instanceof Integer) {
                    return object;
                }
                if (object instanceof Long) {
                    return ((Long)object).intValue();
                }
                if (object instanceof byte[]) {
                    return Bytes.toInt((byte[])((byte[])object));
                }
                return object;
            }
            case "I32": 
            case "SHORT": {
                if (object instanceof String) {
                    return Short.parseShort((String)object);
                }
                if (object instanceof Short) {
                    return object;
                }
                if (object instanceof Float) {
                    return ((Float)object).shortValue();
                }
                if (object instanceof Double) {
                    return ((Double)object).shortValue();
                }
                if (object instanceof Integer) {
                    return ((Integer)object).shortValue();
                }
                if (object instanceof Long) {
                    return ((Long)object).shortValue();
                }
                if (object instanceof byte[]) {
                    return Bytes.toShort((byte[])((byte[])object));
                }
                return object;
            }
            case "LONG": {
                if (object instanceof String) {
                    return Long.parseLong((String)object);
                }
                if (object instanceof Short) {
                    return ((Short)object).longValue();
                }
                if (object instanceof Float) {
                    return ((Float)object).longValue();
                }
                if (object instanceof Double) {
                    return ((Double)object).longValue();
                }
                if (object instanceof Integer) {
                    return ((Integer)object).longValue();
                }
                if (object instanceof Long) {
                    return object;
                }
                if (object instanceof byte[]) {
                    return Bytes.toLong((byte[])((byte[])object));
                }
                return object;
            }
            case "BOOL": 
            case "BOOLEAN": {
                if (object instanceof String) {
                    return Boolean.parseBoolean((String)object);
                }
                if (object instanceof Short) {
                    return (Short)object > 0;
                }
                if (object instanceof Float) {
                    return ((Float)object).floatValue() > 0.0f;
                }
                if (object instanceof Double) {
                    return (Double)object > 0.0;
                }
                if (object instanceof Integer) {
                    return (Integer)object > 0;
                }
                if (object instanceof Long) {
                    return (Long)object > 0L;
                }
                if (object instanceof byte[]) {
                    return Bytes.toBoolean((byte[])((byte[])object));
                }
                return object;
            }
            case "STRING": {
                if (object instanceof String) {
                    return object;
                }
                if (object instanceof Short) {
                    return Short.toString((Short)object);
                }
                if (object instanceof Float) {
                    return Float.toString(((Float)object).floatValue());
                }
                if (object instanceof Double) {
                    return Double.toString((Double)object);
                }
                if (object instanceof Integer) {
                    return Integer.toString((Integer)object);
                }
                if (object instanceof Long) {
                    return Long.toString((Long)object);
                }
                if (object instanceof byte[]) {
                    return Bytes.toString((byte[])((byte[])object));
                }
                if (object instanceof Boolean) {
                    return Boolean.toString((Boolean)object);
                }
                return object;
            }
            case "FLOAT": {
                if (object instanceof String) {
                    return Float.valueOf(Float.parseFloat((String)object));
                }
                if (object instanceof Short) {
                    return Float.valueOf(((Short)object).floatValue());
                }
                if (object instanceof Float) {
                    return object;
                }
                if (object instanceof Double) {
                    return Float.valueOf(((Double)object).floatValue());
                }
                if (object instanceof Integer) {
                    return Float.valueOf(((Integer)object).floatValue());
                }
                if (object instanceof Long) {
                    return Float.valueOf(((Long)object).floatValue());
                }
                if (object instanceof byte[]) {
                    return Float.valueOf(Bytes.toFloat((byte[])((byte[])object)));
                }
                return object;
            }
            case "DOUBLE": {
                if (object instanceof String) {
                    return Double.parseDouble((String)object);
                }
                if (object instanceof Short) {
                    return ((Short)object).doubleValue();
                }
                if (object instanceof Float) {
                    return ((Float)object).doubleValue();
                }
                if (object instanceof Double) {
                    return object;
                }
                if (object instanceof Integer) {
                    return ((Integer)object).doubleValue();
                }
                if (object instanceof Long) {
                    return ((Long)object).doubleValue();
                }
                if (object instanceof byte[]) {
                    return Bytes.toDouble((byte[])((byte[])object));
                }
                return object;
            }
            case "BYTES": {
                if (object instanceof String) {
                    return Bytes.toBytes((String)((String)object));
                }
                if (object instanceof Short) {
                    return Bytes.toBytes((short)((Short)object));
                }
                if (object instanceof Float) {
                    return Bytes.toBytes((float)((Float)object).floatValue());
                }
                if (object instanceof Double) {
                    return Bytes.toBytes((double)((Double)object));
                }
                if (object instanceof Integer) {
                    return Bytes.toBytes((int)((Integer)object));
                }
                if (object instanceof Long) {
                    return Bytes.toBytes((long)((Long)object));
                }
                if (object instanceof byte[]) {
                    return object;
                }
                return object;
            }
        }
        throw new DirectiveExecutionException(String.format("Column '%s' is of unsupported type '%s'. Supported types are: int, short, long, double, boolean, string, bytes", col, toType));
    }
}

