/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.utils;

import io.cdap.wrangler.utils.AvroSchemaLoader;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.commons.collections4.SetValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSchemaGlossary {
    private static final Logger LOG = LoggerFactory.getLogger(AvroSchemaGlossary.class);
    private static final String REVISION_PROPERTY = "_revision";
    private AvroSchemaLoader avroSchemaLoader;
    private SetValuedMap<String, Schema> glossary = new HashSetValuedHashMap();

    public AvroSchemaGlossary(AvroSchemaLoader avroSchemaLoader) {
        this.avroSchemaLoader = avroSchemaLoader;
    }

    public void setAvroSchemaLoader(AvroSchemaLoader avroSchemaLoader) {
        this.avroSchemaLoader = avroSchemaLoader;
    }

    public boolean configure() {
        try {
            this.glossary = this.avroSchemaLoader.load();
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public Schema get(String name, long revision) {
        Set schemas = this.glossary.get((Object)name);
        Schema result = null;
        for (Schema schema : schemas) {
            try {
                long rev = Long.parseLong(schema.getProp(REVISION_PROPERTY), 10);
                if (rev != revision) continue;
                result = schema;
                break;
            }
            catch (NumberFormatException e) {
                LOG.error(String.format("unable to parse %s property within schema %s", REVISION_PROPERTY, schema.getFullName()));
            }
        }
        return result;
    }

    public Collection<Schema> getAll() {
        return this.glossary.entries().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }
}

