/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.sampling;

import com.google.common.base.Preconditions;
import io.cdap.wrangler.sampling.Sampler;
import io.cdap.wrangler.sampling.SamplingIterator;
import io.cdap.wrangler.sampling.XORShiftRNG;
import java.util.Iterator;
import java.util.Random;

public class Bernoulli<T>
extends Sampler<T> {
    private final double fraction;
    private final Random random;
    private static final double THRESHOLD = 0.33;

    public Bernoulli(double fraction) {
        this(fraction, new XORShiftRNG());
    }

    public Bernoulli(double fraction, long seed) {
        this(fraction, new XORShiftRNG(seed));
    }

    public Bernoulli(double fraction, Random random) {
        Preconditions.checkArgument((fraction >= 0.0 && fraction <= 1.0 ? 1 : 0) != 0, (Object)"Fraction must between [0, 1].");
        this.fraction = fraction;
        this.random = random;
    }

    @Override
    public Iterator<T> sample(final Iterator<T> input) {
        if (this.fraction == 0.0) {
            return this.emptyIterable;
        }
        return new SamplingIterator<T>(){
            T current = null;

            @Override
            public boolean hasNext() {
                if (this.current == null) {
                    this.current = this.getNextSampledElement();
                }
                return this.current != null;
            }

            @Override
            public T next() {
                if (this.current == null) {
                    return this.getNextSampledElement();
                }
                Object result = this.current;
                this.current = null;
                return result;
            }

            private T getNextSampledElement() {
                if (Bernoulli.this.fraction <= 0.33) {
                    double rand = Bernoulli.this.random.nextDouble();
                    double u = Math.max(rand, 1.0E-5);
                    int gap = (int)(Math.log(u) / Math.log(1.0 - Bernoulli.this.fraction));
                    if (input.hasNext()) {
                        int elementCount;
                        Object element = input.next();
                        for (elementCount = 0; input.hasNext() && elementCount < gap; ++elementCount) {
                            element = input.next();
                        }
                        if (elementCount < gap) {
                            return null;
                        }
                        return element;
                    }
                    return null;
                }
                while (input.hasNext()) {
                    Object element = input.next();
                    if (!(Bernoulli.this.random.nextDouble() <= Bernoulli.this.fraction)) continue;
                    return element;
                }
                return null;
            }
        };
    }
}

