/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.registry;

import com.google.gson.annotations.SerializedName;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.parser.UsageDefinition;

public final class DirectiveInfo {
    private final String plugin;
    private final String usage;
    private final String description;
    @SerializedName(value="class")
    private final String directiveClass;
    private final UsageDefinition definition;
    private final Scope scope;
    private final boolean deprecated;
    private final String[] categories;
    private final transient Class<?> directive;

    public DirectiveInfo(Scope scope, Class<? extends Directive> directive) throws IllegalAccessException, InstantiationException {
        this.scope = scope;
        this.directive = directive;
        Directive object = directive.newInstance();
        this.definition = object.define();
        this.usage = this.definition != null ? this.definition.toString() : "No definition available for directive '" + directive + "'";
        this.plugin = directive.getAnnotation(Name.class).value();
        Description desc = directive.getAnnotation(Description.class);
        this.description = desc == null ? "No description specified for directive class '" + directive.getSimpleName() + "'" : desc.value();
        Deprecated annotation = directive.getAnnotation(Deprecated.class);
        this.deprecated = annotation != null;
        Categories category = directive.getAnnotation(Categories.class);
        this.categories = category == null ? new String[]{"default"} : category.categories();
        this.directiveClass = directive.getCanonicalName();
    }

    public boolean deprecated() {
        return this.deprecated;
    }

    public Scope scope() {
        return this.scope;
    }

    public String name() {
        return this.plugin;
    }

    public String usage() {
        return this.usage;
    }

    public String description() {
        return this.description;
    }

    public UsageDefinition definition() {
        return this.definition;
    }

    public String[] categories() {
        return this.categories;
    }

    public Directive instance() throws IllegalAccessException, InstantiationException {
        return (Directive)this.directive.newInstance();
    }

    public static enum Scope {
        SYSTEM,
        USER;

    }
}

