/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.registry;

import com.google.common.collect.Iterables;
import io.cdap.wrangler.api.DirectiveLoadException;
import io.cdap.wrangler.registry.DirectiveInfo;
import io.cdap.wrangler.registry.DirectiveRegistry;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.Nullable;

public final class CompositeDirectiveRegistry
implements DirectiveRegistry {
    private final DirectiveRegistry[] registries;

    public CompositeDirectiveRegistry(DirectiveRegistry ... registries) {
        this.registries = registries;
    }

    @Override
    @Nullable
    public DirectiveInfo get(String namespace, String directive) throws DirectiveLoadException {
        for (int i = 0; i < this.registries.length; ++i) {
            DirectiveInfo info = this.registries[i].get(namespace, directive);
            if (info == null) continue;
            return info;
        }
        return null;
    }

    @Override
    public void reload(String namespace) throws DirectiveLoadException {
        for (int idx = 0; idx < this.registries.length; ++idx) {
            this.registries[idx].reload(namespace);
        }
    }

    @Override
    public Iterable<DirectiveInfo> list(String namespace) {
        ArrayList<Iterable<DirectiveInfo>> lists = new ArrayList<Iterable<DirectiveInfo>>();
        for (DirectiveRegistry registry : this.registries) {
            lists.add(registry.list(namespace));
        }
        return Iterables.concat(lists);
    }

    @Override
    public void close() throws IOException {
        for (int idx = 0; idx < this.registries.length; ++idx) {
            this.registries[idx].close();
        }
    }
}

