/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.parser;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.TokenGroup;
import io.cdap.wrangler.api.parser.Bool;
import io.cdap.wrangler.api.parser.BoolList;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.ColumnNameList;
import io.cdap.wrangler.api.parser.Numeric;
import io.cdap.wrangler.api.parser.NumericList;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TextList;
import io.cdap.wrangler.api.parser.Token;
import io.cdap.wrangler.api.parser.TokenDefinition;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class MapArguments
implements Arguments {
    private final Map<String, Token> tokens = new HashMap<String, Token>();
    private final int lineno;
    private final int columnno;
    private final String source;

    public MapArguments(UsageDefinition definition, TokenGroup group) throws DirectiveParseException {
        this.lineno = group.getSourceInfo().getLineNumber();
        this.columnno = group.getSourceInfo().getColumnNumber();
        this.source = group.getSourceInfo().getSource();
        int required = definition.getTokens().size() - definition.getOptionalTokensCount();
        if (required > group.size() - 1 || group.size() - 1 > definition.getTokens().size()) {
            throw new DirectiveParseException(definition.getDirectiveName(), String.format("Improper usage of directive '%s', usage - '%s'", definition.getDirectiveName(), definition.toString()));
        }
        List specifications = definition.getTokens();
        Iterator it = group.iterator();
        int pos = 0;
        it.next();
        block0: while (it.hasNext()) {
            Token token = (Token)it.next();
            while (pos < specifications.size()) {
                TokenDefinition specification = (TokenDefinition)specifications.get(pos);
                if (!specification.optional()) {
                    if (!specification.type().equals((Object)token.type())) {
                        ArrayList<Object> values;
                        if (specification.type() == TokenType.COLUMN_NAME_LIST && token.type() == TokenType.COLUMN_NAME) {
                            values = new ArrayList<Object>();
                            values.add(((ColumnName)token).value());
                            this.tokens.put(specification.name(), (Token)new ColumnNameList(values));
                            ++pos;
                            continue block0;
                        }
                        if (specification.type() == TokenType.NUMERIC_LIST && token.type() == TokenType.NUMERIC) {
                            values = new ArrayList();
                            values.add(((Numeric)token).value());
                            this.tokens.put(specification.name(), (Token)new NumericList(values));
                            ++pos;
                            continue block0;
                        }
                        if (specification.type() == TokenType.BOOLEAN_LIST && token.type() == TokenType.BOOLEAN) {
                            values = new ArrayList();
                            values.add(((Bool)token).value());
                            this.tokens.put(specification.name(), (Token)new BoolList(values));
                            ++pos;
                            continue block0;
                        }
                        if (specification.type() == TokenType.TEXT_LIST && token.type() == TokenType.TEXT) {
                            values = new ArrayList();
                            values.add(((Text)token).value());
                            this.tokens.put(specification.name(), (Token)new TextList(values));
                            ++pos;
                            continue block0;
                        }
                        throw new DirectiveParseException(String.format("Expected argument '%s' to be of type '%s', but it is of type '%s' - %s", specification.name(), specification.type().name(), token.type().name(), group.getSourceInfo().toString()));
                    }
                    this.tokens.put(specification.name(), token);
                    ++pos;
                    continue block0;
                }
                ++pos;
                if (!specification.type().equals((Object)token.type())) continue;
                this.tokens.put(specification.name(), token);
                continue block0;
            }
        }
    }

    public int size() {
        return this.tokens.size();
    }

    public boolean contains(String name) {
        return this.tokens.containsKey(name);
    }

    public <T extends Token> T value(String name) {
        return (T)this.tokens.get(name);
    }

    public TokenType type(String name) {
        return this.tokens.get(name).type();
    }

    public int line() {
        return this.lineno;
    }

    public int column() {
        return this.columnno;
    }

    public String source() {
        return this.source;
    }

    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        JsonObject arguments = new JsonObject();
        for (Map.Entry<String, Token> entry : this.tokens.entrySet()) {
            arguments.add(entry.getKey(), entry.getValue().toJson());
        }
        object.addProperty("line", (Number)this.lineno);
        object.addProperty("column", (Number)this.columnno);
        object.addProperty("source", this.source);
        object.add("arguments", (JsonElement)arguments);
        return object;
    }
}

