/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.lineage;

import com.google.common.collect.Sets;
import io.cdap.cdap.etl.api.lineage.field.FieldOperation;
import io.cdap.cdap.etl.api.lineage.field.FieldTransformOperation;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.lineage.Relation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LineageOperations {
    private static final Logger LOG = LoggerFactory.getLogger(LineageOperations.class);
    private static final String OPERATION_NAME_PREFIX = "operation_";
    private final Set<String> input;
    private final Set<String> output;
    private final List<Directive> directives;

    public LineageOperations(Set<String> input, Set<String> output, List<Directive> directives) {
        this.input = Collections.unmodifiableSet(new HashSet<String>(input));
        this.output = Collections.unmodifiableSet(new HashSet<String>(output));
        this.directives = Collections.unmodifiableList(new ArrayList<Directive>(directives));
    }

    public List<FieldOperation> generate() {
        ArrayList<FieldOperation> operations = new ArrayList<FieldOperation>();
        HashSet definedSources = new HashSet();
        HashSet<String> availableSources = new HashSet<String>(this.input);
        int lastAllOperationIndex = -1;
        HashSet<String> lastAllOutput = new HashSet<String>();
        for (Directive directive : this.directives) {
            if (!(directive instanceof Lineage)) continue;
            Mutation mutation = ((Lineage)directive).lineage();
            String readable = mutation.readable();
            for (Relation relation : mutation.relations()) {
                String name = OPERATION_NAME_PREFIX + operations.size();
                ArrayList<String> sources = relation.getSources();
                ArrayList targets = relation.getTargets();
                switch (relation.getType()) {
                    case ALL: {
                        sources = sources.isEmpty() ? new ArrayList<String>(this.input) : sources;
                        this.checkAndSetActualFields(operations, availableSources, lastAllOperationIndex, lastAllOutput, sources);
                        HashSet outputs = new HashSet(Sets.difference(this.output, availableSources));
                        outputs.addAll(Sets.intersection(new HashSet<String>(sources), this.output));
                        outputs.addAll(targets);
                        targets = new ArrayList(outputs);
                        operations.add((FieldOperation)new FieldTransformOperation(name, readable, sources, targets));
                        lastAllOperationIndex = operations.size() - 1;
                        lastAllOutput = new HashSet(targets);
                        break;
                    }
                    case GENERATE: {
                        sources = new ArrayList<String>(this.input);
                        operations.add((FieldOperation)new FieldTransformOperation(name, readable, sources, (List)targets));
                        break;
                    }
                    case DROP: {
                        this.checkAndSetActualFields(operations, availableSources, lastAllOperationIndex, lastAllOutput, sources);
                        operations.add((FieldOperation)new FieldTransformOperation(name, readable, sources, new String[0]));
                        break;
                    }
                    case CREATE: {
                        this.checkAndSetActualFields(operations, availableSources, lastAllOperationIndex, lastAllOutput, sources);
                        operations.add((FieldOperation)new FieldTransformOperation(name, readable, Collections.emptyList(), (List)targets));
                        break;
                    }
                    case STANDARD: {
                        this.checkAndSetActualFields(operations, availableSources, lastAllOperationIndex, lastAllOutput, sources);
                        operations.add((FieldOperation)new FieldTransformOperation(name, readable, sources, (List)targets));
                    }
                }
                availableSources.addAll(targets);
                definedSources.addAll(relation.getSources());
            }
        }
        Sets.SetView difference = Sets.difference(this.input, definedSources);
        for (String next : difference) {
            if (!this.output.contains(next)) continue;
            FieldTransformOperation transformation = new FieldTransformOperation(OPERATION_NAME_PREFIX + operations.size(), String.format("Mapping column '%s' to column '%s'", next, next), Collections.singletonList(next), new String[]{next});
            operations.add((FieldOperation)transformation);
        }
        return operations;
    }

    private void checkAndSetActualFields(List<FieldOperation> operations, Set<String> availableSources, int lastAllIndex, Set<String> lastAllOutputFields, List<String> inputFields) {
        if (availableSources.containsAll(inputFields)) {
            return;
        }
        if (lastAllIndex == -1) {
            LOG.warn("The input fields {} contains fields that are neither in input schema nor generated by other field operations, field operations might not be recorded.", inputFields);
            return;
        }
        Sets.SetView actualFields = Sets.difference(new HashSet<String>(inputFields), availableSources);
        lastAllOutputFields.addAll((Collection<String>)actualFields);
        availableSources.addAll((Collection<String>)actualFields);
        FieldTransformOperation operation = (FieldTransformOperation)operations.get(lastAllIndex);
        operations.set(lastAllIndex, (FieldOperation)new FieldTransformOperation(operation.getName(), operation.getDescription(), operation.getInputFields(), new ArrayList<String>(lastAllOutputFields)));
    }
}

