/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.i18n;

import io.cdap.wrangler.api.annotations.Public;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

@Public
public final class Messages {
    private static ResourceBundle bundle;
    private final String name;
    private final Locale locale;

    public Messages() {
        this("user/messages", Locale.getDefault());
    }

    public Messages(String name) {
        this(name, Locale.getDefault());
    }

    public Messages(String name, Locale locale) {
        this.name = name;
        this.locale = locale;
        bundle = ResourceBundle.getBundle(name, locale, Messages.class.getClassLoader());
    }

    public String get(String key) {
        if (bundle == null) {
            return String.format("Key '%s' not found in bundle '%s' and locale '%s'", key, this.name, this.locale.toString());
        }
        try {
            return bundle.getString(key);
        }
        catch (MissingResourceException e) {
            return String.format("Key '%s' not found in bundle '%s' and locale '%s'", key, this.name, this.locale.toString());
        }
    }

    public String get(String key, Object ... args) {
        return MessageFormat.format(this.get(key), args);
    }
}

