/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.expression;

import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.expression.EL;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.jexl3.JexlContext;

public class ELContext
implements JexlContext {
    private final Map<String, Object> values = new HashMap<String, Object>();

    public ELContext() {
    }

    public ELContext(ExecutorContext context) {
        this.init(context);
    }

    public ELContext(ExecutorContext context, EL el, Row row) {
        for (String var : el.variables()) {
            this.set(var, row.getValue(var));
        }
        this.init(context);
        this.set("this", row);
    }

    @Nullable
    private void init(ExecutorContext context) {
        if (context != null) {
            for (String variable : context.getTransientStore().getVariables()) {
                this.set(variable, context.getTransientStore().get(variable));
            }
            this.set("ctx", new Context(context.getEnvironment().name(), context.getContextName()));
        }
    }

    public ELContext(String name, Object object) {
        this.values.put(name, object);
    }

    public ELContext(Map<String, Object> values) {
        this.values.putAll(values);
    }

    public Object get(String name) {
        return this.values.get(name);
    }

    public void set(String name, Object value) {
        this.values.put(name, value);
    }

    public ELContext add(String name, Object value) {
        this.values.put(name, value);
        return this;
    }

    public boolean has(String name) {
        return this.values.containsKey(name);
    }

    public static class Context {
        public final String environment;
        public final String name;
        public final long nano;
        public final long millis;

        public Context(String environment, String name) {
            this.environment = environment;
            this.name = name;
            this.nano = System.nanoTime();
            this.millis = this.nano / 1000L;
        }
    }
}

