/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.expression;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import io.cdap.cdap.api.common.Bytes;
import io.cdap.functions.DDL;
import io.cdap.functions.DataQuality;
import io.cdap.functions.DateAndTime;
import io.cdap.functions.Dates;
import io.cdap.functions.GeoFences;
import io.cdap.functions.Global;
import io.cdap.functions.JsonFunctions;
import io.cdap.functions.Logical;
import io.cdap.functions.NumberFunctions;
import io.cdap.wrangler.expression.ELContext;
import io.cdap.wrangler.expression.ELException;
import io.cdap.wrangler.expression.ELRegistration;
import io.cdap.wrangler.expression.ELResult;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.jexl3.JexlBuilder;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.jexl3.JexlInfo;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.logging.Log;

public final class EL {
    private Set<String> variables = new HashSet<String>();
    private final JexlEngine engine;
    private JexlScript script = null;

    public EL(ELRegistration registration) {
        this.engine = new JexlBuilder().namespaces(registration.functions()).silent(false).cache(1024).strict(true).logger((Log)new NullLogger()).create();
    }

    public void compile(String expression) throws ELException {
        this.variables.clear();
        try {
            this.script = this.engine.createScript(expression);
            Set varSet = this.script.getVariables();
            for (List vars : varSet) {
                this.variables.add(Joiner.on((String)".").join((Iterable)vars));
            }
        }
        catch (JexlException e) {
            JexlInfo info = e.getInfo();
            throw new ELException(String.format("Error encountered while executing '%s' at line '%d' and column '%d'. Make sure a valid jexl transformation is provided.", info.getDetail().toString(), info.getLine(), info.getColumn()), e);
        }
        catch (Exception e) {
            throw new ELException(e);
        }
    }

    public Set<String> variables() {
        return this.variables;
    }

    public ELResult execute(ELContext context, boolean nullMissingFields) throws ELException {
        try {
            if (nullMissingFields) {
                for (String string : this.variables) {
                    if (context.has(string)) continue;
                    context.add(string, null);
                }
            }
            Object value = this.script.execute((JexlContext)context);
            ELResult eLResult = new ELResult(value);
            return eLResult;
        }
        catch (JexlException e) {
            JexlInfo jexlInfo = e.getInfo();
            throw new ELException(String.format("Error encountered while executing '%s', at line '%d' and column '%d'. Make sure a valid jexl transformation is provided.", jexlInfo.getDetail().toString(), jexlInfo.getLine(), jexlInfo.getColumn()), e);
        }
        catch (NumberFormatException e) {
            throw new ELException("Type mismatch. Change type of constant or convert to right data type using conversion functions available. Reason : " + e.getMessage(), e);
        }
        catch (Exception e) {
            if (e.getCause() != null) {
                throw new ELException(e.getCause().getMessage(), e);
            }
            throw new ELException(e);
        }
    }

    public ELResult execute(ELContext context) throws ELException {
        return this.execute(context, true);
    }

    private final class NullLogger
    implements Log {
        private NullLogger() {
        }

        public void debug(Object o) {
        }

        public void debug(Object o, Throwable throwable) {
        }

        public void error(Object o) {
        }

        public void error(Object o, Throwable throwable) {
        }

        public void fatal(Object o) {
        }

        public void fatal(Object o, Throwable throwable) {
        }

        public void info(Object o) {
        }

        public void info(Object o, Throwable throwable) {
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public boolean isErrorEnabled() {
            return false;
        }

        public boolean isFatalEnabled() {
            return false;
        }

        public boolean isInfoEnabled() {
            return false;
        }

        public boolean isTraceEnabled() {
            return false;
        }

        public boolean isWarnEnabled() {
            return false;
        }

        public void trace(Object o) {
        }

        public void trace(Object o, Throwable throwable) {
        }

        public void warn(Object o) {
        }

        public void warn(Object o, Throwable throwable) {
        }
    }

    public static final class DefaultFunctions
    implements ELRegistration {
        @Override
        public Map<String, Object> functions() {
            HashMap<String, Object> functions = new HashMap<String, Object>();
            functions.put(null, Global.class);
            functions.put("datetime", DateAndTime.class);
            functions.put("date", Dates.class);
            functions.put("json", JsonFunctions.class);
            functions.put("math", Math.class);
            functions.put("string", StringUtils.class);
            functions.put("strings", Strings.class);
            functions.put("escape", StringEscapeUtils.class);
            functions.put("bytes", Bytes.class);
            functions.put("arrays", Arrays.class);
            functions.put("dq", DataQuality.class);
            functions.put("ddl", DDL.class);
            functions.put("geo", GeoFences.class);
            functions.put("number", NumberFunctions.class);
            functions.put("logical", Logical.class);
            return functions;
        }
    }
}

