/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.executor;

import com.google.common.collect.Lists;
import io.cdap.cdap.api.data.format.StructuredRecord;
import io.cdap.cdap.api.data.schema.Schema;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveLoadException;
import io.cdap.wrangler.api.DirectiveNotFoundException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRecord;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.Executor;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.RecipeException;
import io.cdap.wrangler.api.RecipeParser;
import io.cdap.wrangler.api.RecipePipeline;
import io.cdap.wrangler.api.ReportErrorAndProceed;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.TransientVariableScope;
import io.cdap.wrangler.executor.ErrorRecordCollector;
import io.cdap.wrangler.utils.RecordConvertor;
import io.cdap.wrangler.utils.RecordConvertorException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RecipePipelineExecutor
implements RecipePipeline<Row, StructuredRecord, ErrorRecord> {
    private static final Logger LOG = LoggerFactory.getLogger(RecipePipelineExecutor.class);
    private ExecutorContext context;
    private List<Directive> directives;
    private final ErrorRecordCollector collector = new ErrorRecordCollector();
    private RecordConvertor convertor = new RecordConvertor();

    public void initialize(RecipeParser parser, ExecutorContext context) throws RecipeException {
        this.context = context;
        try {
            this.directives = parser.parse();
        }
        catch (DirectiveParseException e) {
            throw new RecipeException(e.getMessage());
        }
        catch (DirectiveLoadException | DirectiveNotFoundException e) {
            throw new RecipeException(e.getMessage(), e);
        }
    }

    public void destroy() {
        for (Executor executor : this.directives) {
            try {
                executor.destroy();
            }
            catch (Throwable t) {
                LOG.warn(t.getMessage());
            }
        }
    }

    public List<StructuredRecord> execute(List<Row> rows, Schema schema) throws RecipeException {
        rows = this.execute(rows);
        try {
            List<StructuredRecord> output = this.convertor.toStructureRecord(rows, schema);
            return output;
        }
        catch (RecordConvertorException e) {
            throw new RecipeException("Problem converting into output record. Reason : " + e.getMessage(), (Throwable)e);
        }
    }

    public List<Row> execute(List<Row> rows) throws RecipeException {
        ArrayList<String> messages = new ArrayList<String>();
        ArrayList results = Lists.newArrayList();
        try {
            this.collector.reset();
            for (int i = 0; i < rows.size(); ++i) {
                messages.clear();
                if (this.context != null) {
                    this.context.getTransientStore().reset(TransientVariableScope.LOCAL);
                }
                ArrayList cumulativeRows = rows.subList(i, i + 1);
                try {
                    for (Executor executor : this.directives) {
                        try {
                            if ((cumulativeRows = (ArrayList)executor.execute(cumulativeRows, this.context)).size() >= 1) continue;
                        }
                        catch (ReportErrorAndProceed e) {
                            messages.add(String.format("%s (ecode: %d)", e.getMessage(), e.getCode()));
                            this.collector.add(new ErrorRecord(rows.subList(i, i + 1).get(0), String.join((CharSequence)",", messages), e.getCode(), true));
                            cumulativeRows = new ArrayList();
                        }
                        break;
                    }
                    results.addAll(cumulativeRows);
                    continue;
                }
                catch (ErrorRowException e) {
                    messages.add(String.format("%s", e.getMessage()));
                    this.collector.add(new ErrorRecord(rows.subList(i, i + 1).get(0), String.join((CharSequence)",", messages), e.getCode(), e.isShownInWrangler()));
                }
            }
        }
        catch (DirectiveExecutionException e) {
            throw new RecipeException(e.getMessage(), (Throwable)e);
        }
        return results;
    }

    public List<ErrorRecord> errors() {
        return this.collector.get();
    }
}

