/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.dq;

import java.math.BigDecimal;
import javax.annotation.Nullable;

public final class ConvertDistances {
    private Distance from;
    private Distance to;
    private BigDecimal multiplier;

    public ConvertDistances() {
        this(Distance.MILE, Distance.KILOMETER);
    }

    @Nullable
    public ConvertDistances(Distance from, Distance to) {
        this.from = from == null ? Distance.MILE : from;
        this.to = to == null ? Distance.KILOMETER : to;
        this.multiplier = new BigDecimal(String.valueOf(this.from.getToBase())).multiply(new BigDecimal(String.valueOf(this.to.getFromBase())));
    }

    public double convert(double value) {
        if (Double.isNaN(value)) {
            return value;
        }
        if (this.from.equals((Object)this.to)) {
            return value;
        }
        BigDecimal result = new BigDecimal(String.valueOf(value)).multiply(this.multiplier);
        return result.doubleValue();
    }

    public static enum Distance {
        MILLIMETER("millimeter", "mm", 0.001, 1000.0),
        CENTIMETER("centimeter", "cm", 0.01, 100.0),
        DECIMETER("decimeter", "dm", 0.1, 10.0),
        METER("meter", "m", 1.0, 1.0),
        DEKAMETER("dekameter", "dam", 10.0, 0.1),
        HECTOMETER("hectometer", "hm", 100.0, 0.01),
        KILOMETER("kilometer", "km", 1000.0, 0.001),
        INCH("inch", "in", 0.0254, 39.37007874015748),
        FOOT("foot", "ft", 0.3048, 3.2808398950131235),
        YARD("yard", "yd", 0.9144, 1.0936132983377078),
        MILE("mile", "mi", 1609.344, 6.213711922373339E-4),
        NAUTICAL_MILE("nautical mile", "nm", 1852.0, 5.399568034557236E-4),
        LIGHT_YEAR("light-year", "ly", 9.4607304725808E15, 1.0570008340246154E-16);

        private String name;
        private String measure;
        private double toBase;
        private double fromBase;

        private Distance(String name, String measure, double toBase, double fromBase) {
            this.name = name;
            this.measure = measure;
            this.toBase = toBase;
            this.fromBase = fromBase;
        }

        public String getName() {
            return this.name;
        }

        public String getMeasureName() {
            return this.measure;
        }

        public double getToBase() {
            return this.toBase;
        }

        public double getFromBase() {
            return this.fromBase;
        }
    }
}

