/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.datamodel;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.cdap.wrangler.clients.RestClientException;
import io.cdap.wrangler.utils.AvroSchemaLoader;
import io.cdap.wrangler.utils.Manifest;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import org.apache.avro.Schema;
import org.apache.commons.collections4.SetValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HTTPSchemaLoader
implements AvroSchemaLoader {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPSchemaLoader.class);
    private static final String FORMAT = "avsc";
    private static final String REQUEST_METHOD = "GET";
    private final Gson gson = new GsonBuilder().create();
    private final String baseUrl;
    private final String manifestName;
    private int connectionTimeout;
    private int readTimeout;
    private String acceptEncoding;

    public HTTPSchemaLoader(String baseUrl, String manifestName) {
        this.baseUrl = baseUrl;
        this.manifestName = manifestName;
        this.connectionTimeout = 2000;
        this.readTimeout = 1000;
        this.acceptEncoding = "application/json";
    }

    @Override
    public SetValuedMap<String, Schema> load() throws IOException {
        Manifest manifest = this.downloadResource(this.baseUrl, this.manifestName, is -> (Manifest)this.gson.fromJson((Reader)new InputStreamReader((InputStream)is), Manifest.class));
        if (manifest == null) {
            throw new IOException("unable to download the manifest resource.");
        }
        return this.downloadSchemas(manifest);
    }

    private SetValuedMap<String, Schema> downloadSchemas(Manifest manifest) throws IOException {
        HashSetValuedHashMap avroSchemas = new HashSetValuedHashMap();
        if (manifest.getStandards() == null) {
            return avroSchemas;
        }
        Schema.Parser parser = new Schema.Parser().setValidate(false);
        for (Map.Entry<String, Manifest.Standard> spec : manifest.getStandards().entrySet()) {
            String resource;
            Schema schema;
            if (!spec.getValue().getFormat().equals(FORMAT) || (schema = this.downloadResource(this.baseUrl, resource = String.format("%s.%s", spec.getKey(), FORMAT), is -> {
                try {
                    return parser.parse(is);
                }
                catch (Exception e) {
                    LOG.warn(String.format("Unable to parse resource %s due to error: %s", resource, e.getMessage()));
                    return null;
                }
            })) == null) continue;
            avroSchemas.put((Object)schema.getFullName(), (Object)schema);
        }
        return avroSchemas;
    }

    private <R> R downloadResource(String baseUrl, String resourceName, Function<InputStream, R> callable) {
        R resource = null;
        try {
            URL resourceURL = this.concat(new URI(baseUrl), resourceName).toURL();
            resource = this.getRequest(resourceURL, callable);
        }
        catch (IOException e) {
            LOG.warn(String.format("Unable to download resource %s at %s", resourceName, baseUrl));
        }
        catch (RestClientException r) {
            LOG.warn(String.format("Failed to make request to due to error %s", r.getMessage()));
        }
        catch (Exception e) {
            LOG.warn(String.format("Unable to generate resource url for %s/%s", baseUrl, resourceName));
            return null;
        }
        return resource;
    }

    private <R> R getRequest(URL url, Function<InputStream, R> callable) throws IOException, RestClientException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(REQUEST_METHOD);
            connection.setConnectTimeout(this.connectionTimeout);
            connection.setReadTimeout(this.readTimeout);
            connection.setUseCaches(false);
            connection.setRequestProperty("Accept", this.acceptEncoding);
            int responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 200: {
                    InputStream is = connection.getInputStream();
                    R result = callable.apply(is);
                    is.close();
                    R r = result;
                    return r;
                }
                case 204: {
                    R r = null;
                    return r;
                }
            }
            String response = "";
            InputStream es = connection.getErrorStream();
            if (es != null) {
                response = IOUtils.toString((InputStream)es, (Charset)StandardCharsets.UTF_8);
                es.close();
            }
            throw new RestClientException(responseCode, response);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private URI concat(URI uri, String extraPath) {
        String separator = uri.getPath().endsWith("/") ? "" : "/";
        String newPath = String.format("%s%s%s", uri.getPath(), separator, extraPath);
        return uri.resolve(newPath);
    }
}

