/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.codec;

import com.google.gson.Gson;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.codec.Decoder;
import io.cdap.wrangler.codec.DecoderException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProtobufDecoderUsingDescriptor
implements Decoder<Row> {
    private final Gson gson = new Gson();
    private final Descriptors.Descriptor descriptor;

    public ProtobufDecoderUsingDescriptor(byte[] bytes, String name) throws InvalidProtocolBufferException, Descriptors.DescriptorValidationException {
        DescriptorProtos.FileDescriptorSet fileDescriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((byte[])bytes);
        DescriptorProtos.FileDescriptorProto fileProto = fileDescriptorSet.getFile(0);
        Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileProto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
        this.descriptor = fileDescriptor.findMessageTypeByName(name);
    }

    @Override
    public List<Row> decode(byte[] bytes) throws DecoderException {
        ArrayList<Row> rows = new ArrayList<Row>();
        try {
            DynamicMessage message = DynamicMessage.parseFrom((Descriptors.Descriptor)this.descriptor, (byte[])bytes);
            Row row = new Row();
            this.decodeMessage((Message)message, row, null);
            rows.add(row);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DecoderException(e.getMessage());
        }
        return rows;
    }

    private void decodeMessage(Message message, Row row, String root) {
        block4: for (Map.Entry field : message.getAllFields().entrySet()) {
            String name = ((Descriptors.FieldDescriptor)field.getKey()).getName();
            String fullName = String.format("%s", name);
            if (root != null) {
                fullName = String.format("%s_%s", root, name);
            }
            Descriptors.FieldDescriptor.Type type = ((Descriptors.FieldDescriptor)field.getKey()).getType();
            Object value = field.getValue();
            switch (type) {
                case MESSAGE: {
                    for (Message msg : (List)value) {
                        this.decodeMessage(msg, row, fullName);
                    }
                    continue block4;
                }
                case ENUM: {
                    row.add(fullName, (Object)((Descriptors.EnumValueDescriptor)value).getName());
                    break;
                }
                default: {
                    row.add(fullName, value);
                }
            }
        }
    }
}

