/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.wrangler.clients;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import io.cdap.cdap.api.common.Bytes;
import io.cdap.cdap.internal.guava.reflect.TypeToken;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.clients.Response;
import io.cdap.wrangler.clients.RestClientException;
import io.cdap.wrangler.clients.SchemaInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public final class SchemaRegistryClient {
    private final Gson gson;
    private final String baseUrl;
    private int connectionTimeout;
    private int readTimeout;
    private String acceptEncoding;

    public SchemaRegistryClient(String baseUrl) {
        this.baseUrl = baseUrl;
        this.connectionTimeout = 2000;
        this.readTimeout = 1000;
        this.acceptEncoding = "application/json";
        this.gson = new GsonBuilder().create();
    }

    public static SchemaRegistryClient getInstance(ExecutorContext context) {
        return new SchemaRegistryClient(context.getService("dataprep", "service").toString());
    }

    public byte[] getSchema(String namespace, String id, long version) throws URISyntaxException, IOException, RestClientException {
        URL url = this.concat(new URI(this.baseUrl), String.format("contexts/%s/schemas/%s/versions/%d", namespace, id, version)).toURL();
        Response response = (Response)this.request(url, "GET", new TypeToken<Response<SchemaInfo>>(){}.getType());
        if (response.getCount() == 1) {
            return Bytes.fromHexString((String)((SchemaInfo)response.getValues().get(0)).getSpecification());
        }
        return null;
    }

    public byte[] getSchema(String namespace, String id) throws URISyntaxException, IOException, RestClientException {
        URL url = this.concat(new URI(this.baseUrl), String.format("contexts/%s/schemas/%s", namespace, id)).toURL();
        Response response = (Response)this.request(url, "GET", new TypeToken<Response<SchemaInfo>>(){}.getType());
        if (response.getCount() == 1) {
            return Bytes.fromHexString((String)((SchemaInfo)response.getValues().get(0)).getSpecification());
        }
        return null;
    }

    public List<Long> getVersions(String namespace, String id) throws URISyntaxException, IOException, RestClientException {
        URL url = this.concat(new URI(this.baseUrl), String.format("contexts/%s/schemas/%s/versions", namespace, id)).toURL();
        Response response = (Response)this.request(url, "GET", new TypeToken<Response<Long>>(){}.getType());
        return response.getValues();
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public String getAcceptEncoding() {
        return this.acceptEncoding;
    }

    public void setAcceptEncoding(String acceptEncoding) {
        this.acceptEncoding = acceptEncoding;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    private URI concat(URI uri, String extraPath) throws URISyntaxException, MalformedURLException {
        String newPath = uri.getPath() + '/' + extraPath;
        URI newUri = uri.resolve(newPath);
        return newUri;
    }

    private <T> T request(URL url, String method, Type classz) throws IOException, RestClientException {
        return this.request(url, method, null, new HashMap<String, String>(), classz);
    }

    private <T> T request(URL url, String method, byte[] body, Map<String, String> headers, Type classz) throws IOException, RestClientException {
        HttpURLConnection connection = null;
        try {
            InputStream es;
            InputStream is;
            int responseCode;
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(method);
            connection.setDoInput(true);
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
            connection.setConnectTimeout(this.connectionTimeout);
            connection.setReadTimeout(this.readTimeout);
            connection.setUseCaches(false);
            connection.setRequestProperty("Accept", this.acceptEncoding);
            if (body != null) {
                connection.setDoOutput(true);
                try (OutputStream os = null;){
                    os = connection.getOutputStream();
                    os.write(body);
                    os.flush();
                }
            }
            if ((responseCode = connection.getResponseCode()) == 200) {
                is = connection.getInputStream();
                Object result = this.gson.fromJson((Reader)new InputStreamReader(is), classz);
                is.close();
                Object object = result;
                return (T)object;
            }
            if (responseCode == 204) {
                is = null;
                return (T)is;
            }
            if (responseCode == 500) {
                Response message;
                es = connection.getErrorStream();
                try {
                    message = (Response)this.gson.fromJson((Reader)new InputStreamReader(es), Response.class);
                }
                catch (JsonIOException | JsonSyntaxException e) {
                    throw new RestClientException(responseCode, e.getMessage());
                }
                finally {
                    es.close();
                }
                throw new RestClientException(message.getStatus(), message.getMessage());
            }
            es = connection.getErrorStream();
            String response = IOUtils.toString((InputStream)es, (Charset)StandardCharsets.UTF_8);
            es.close();
            throw new RestClientException(responseCode, response);
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }
}

