/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.functions;

import com.google.common.base.Strings;

public final class Global {
    private Global() {
    }

    public static double toDouble(String value) {
        return Double.parseDouble(value);
    }

    public static float toFloat(String value) {
        return Float.parseFloat(value);
    }

    public static long toLong(String value) {
        return Long.parseLong(value);
    }

    public static int toInteger(String value) {
        return Integer.parseInt(value);
    }

    public static byte[] toBytes(String value) {
        return value.getBytes();
    }

    public static String concat(String a, String b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        return a.concat(b);
    }

    public static String concat(String a, String delim, String b) {
        if (a == null && b != null) {
            return delim.concat(b);
        }
        if (b == null && a != null) {
            return a.concat(delim);
        }
        return a.concat(delim).concat(b);
    }

    public static Object coalesce(Object ... objects) {
        for (Object object : objects) {
            if (object == null) continue;
            return object;
        }
        return objects.length > 0 ? objects[0] : null;
    }

    public static Object rcoalesce(Object ... objects) {
        for (int idx = objects.length - 1; idx >= 0; --idx) {
            if (objects[idx] == null) continue;
            return objects[idx];
        }
        return objects.length > 0 ? objects[objects.length - 1] : null;
    }

    public static String format(String str, Object ... args) {
        return String.format(str, args);
    }

    public static String padAtStart(String string, int minLength, char padChar) {
        return Strings.padStart((String)string, (int)minLength, (char)padChar);
    }

    public static String padAtEnd(String string, int minLength, char padChar) {
        return Strings.padEnd((String)string, (int)minLength, (char)padChar);
    }

    public static String repeat(String string, int count) {
        return Strings.repeat((String)string, (int)count);
    }

    public static String unquote(String string) {
        if (string != null && (string.startsWith("\"") && string.endsWith("\"") || string.startsWith("'") && string.endsWith("'"))) {
            string = string.substring(1, string.length() - 1);
        }
        return string;
    }

    public static boolean IsNotNull(Object value) {
        return value != null;
    }

    public static boolean IsNull(Object value) {
        return !Global.IsNotNull(value);
    }

    public static Object NullToEmpty(Object value) {
        if (Global.IsNull(value)) {
            return "";
        }
        return value;
    }

    public static Object NullToZero(Object value) {
        if (Global.IsNull(value)) {
            return 0;
        }
        return value;
    }

    public static Object NullToValue(Object value, Object replace) {
        if (Global.IsNull(value)) {
            return replace;
        }
        return value;
    }
}

