/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.functions;

import com.github.filosganga.geogson.gson.GeometryAdapterFactory;
import com.github.filosganga.geogson.model.Coordinates;
import com.github.filosganga.geogson.model.Feature;
import com.github.filosganga.geogson.model.FeatureCollection;
import com.github.filosganga.geogson.model.Polygon;
import com.github.filosganga.geogson.model.positions.LinearPositions;
import com.github.filosganga.geogson.model.positions.SinglePosition;
import com.google.common.collect.Lists;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.TypeAdapterFactory;
import java.util.ArrayList;

public final class GeoFences {
    private static final Gson GSON = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new GeometryAdapterFactory()).create();

    private GeoFences() {
    }

    @Deprecated
    public static Boolean inFence(double latitude, double longitude, String geofences) {
        return GeoFences.InFence(latitude, longitude, geofences);
    }

    public static Boolean InFence(Double latitude, Double longitude, String geofences) {
        FeatureCollection featureCollection;
        if (latitude == null || longitude == null || geofences == null) {
            return false;
        }
        Coordinates location = Coordinates.of((double)longitude, (double)latitude);
        boolean inzone = false;
        try {
            featureCollection = (FeatureCollection)GSON.fromJson(geofences, FeatureCollection.class);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("String %s is not a valid geoJson representation of fence", geofences), e);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException(String.format("String %s is not a valid Json string", geofences), e);
        }
        for (Feature feature : featureCollection.features()) {
            inzone = inzone || GeoFences.isPointInside(feature, location) != false;
        }
        return inzone;
    }

    private static Boolean isPointInside(Feature feature, Coordinates location) {
        Polygon polygon = (Polygon)feature.geometry();
        ArrayList positions = Lists.newArrayList((Iterable)((LinearPositions)polygon.perimeter().positions()).children());
        if (positions == null || location == null) {
            return false;
        }
        int wn = 0;
        for (int i = 0; i < positions.size() - 1; ++i) {
            if (((SinglePosition)positions.get(i)).coordinates().getLat() <= location.getLat()) {
                if (!(((SinglePosition)positions.get(i + 1)).coordinates().getLat() > location.getLat()) || !(GeoFences.isLeft(((SinglePosition)positions.get(i)).coordinates(), ((SinglePosition)positions.get(i + 1)).coordinates(), location) > 0.0)) continue;
                ++wn;
                continue;
            }
            if (!(((SinglePosition)positions.get(i + 1)).coordinates().getLat() <= location.getLat()) || !(GeoFences.isLeft(((SinglePosition)positions.get(i)).coordinates(), ((SinglePosition)positions.get(i + 1)).coordinates(), location) < 0.0)) continue;
            --wn;
        }
        return wn != 0;
    }

    private static double isLeft(Coordinates vertex0, Coordinates vertex1, Coordinates gpC) {
        return (vertex1.getLon() - vertex0.getLon()) * (gpC.getLat() - vertex0.getLat()) - (gpC.getLon() - vertex0.getLon()) * (vertex1.getLat() - vertex0.getLat());
    }
}

