/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.functions;

import io.cdap.wrangler.dq.TypeInference;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.TimeZone;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;
import org.joda.time.Seconds;

@Deprecated
public final class Dates {
    public static long UNIXTIMESTAMP_MILLIS(ZonedDateTime date) {
        Dates.validate(date, "UNIXTIMESTAMP_MILLIS");
        return date.toInstant().toEpochMilli();
    }

    public static long UNIXTIMESTAMP_SECONDS(ZonedDateTime date) {
        Dates.validate(date, "UNIXTIMESTAMP_SECONDS");
        return date.toEpochSecond();
    }

    public static int MONTH(ZonedDateTime date) {
        Dates.validate(date, "MONTH");
        return date.getMonthValue();
    }

    public static String MONTH_SHORT(ZonedDateTime date) {
        Dates.validate(date, "MONTH_SHORT");
        DateTime dt = Dates.getDateTime(date);
        DateTime.Property pMoY = dt.monthOfYear();
        return pMoY.getAsShortText();
    }

    public static String MONTH_LONG(ZonedDateTime date) {
        Dates.validate(date, "MONTH_LONG");
        DateTime dt = Dates.getDateTime(date);
        DateTime.Property pMoY = dt.monthOfYear();
        return pMoY.getAsText();
    }

    public static int YEAR(ZonedDateTime date) {
        Dates.validate(date, "YEAR");
        return date.getYear();
    }

    public static int DAY_OF_WEEK(ZonedDateTime date) {
        Dates.validate(date, "DAY_OF_WEEK");
        return date.getDayOfWeek().getValue();
    }

    public static String DAY_OF_WEEK_SHORT(ZonedDateTime date) {
        Dates.validate(date, "DAY_OF_WEEK_SHORT");
        DateTime dt = Dates.getDateTime(date);
        DateTime.Property value = dt.dayOfWeek();
        return value.getAsShortText();
    }

    public static String DAY_OF_WEEK_LONG(ZonedDateTime date) {
        Dates.validate(date, "DAY_OF_WEEK_LONG");
        DateTime dt = Dates.getDateTime(date);
        DateTime.Property value = dt.dayOfWeek();
        return value.getAsText();
    }

    public static int DAY_OF_YEAR(ZonedDateTime date) {
        Dates.validate(date, "DAY_OF_YEAR");
        return date.getDayOfYear();
    }

    public static int ERA(ZonedDateTime date) {
        Dates.validate(date, "ERA");
        return date.get(ChronoField.ERA);
    }

    public static String ERA_SHORT(ZonedDateTime date) {
        Dates.validate(date, "ERA_SHORT");
        DateTime dt = Dates.getDateTime(date);
        DateTime.Property value = dt.era();
        return value.getAsShortText();
    }

    public static String ERA_LONG(ZonedDateTime date) {
        Dates.validate(date, "ERA_LONG");
        DateTime dt = Dates.getDateTime(date);
        DateTime.Property value = dt.era();
        return value.getAsText();
    }

    public static int DAYS_BETWEEN(ZonedDateTime date1, ZonedDateTime date2) {
        Dates.validate(date1, "ERA_LONG");
        Dates.validate(date2, "ERA_LONG");
        return (int)ChronoUnit.DAYS.between(date1, date2);
    }

    public static int DAYS_BETWEEN_NOW(ZonedDateTime date) {
        Dates.validate(date, "DAYS_BETWEEN_NOW");
        ZonedDateTime now = ZonedDateTime.now(ZoneId.ofOffset("UTC", ZoneOffset.UTC));
        return (int)ChronoUnit.DAYS.between(date, now);
    }

    public static int SECONDS_TO_DAYS(int seconds) {
        Period period = new Period((Object)Seconds.seconds((int)seconds));
        return period.toStandardDays().getDays();
    }

    public static int SECONDS_TO_HOURS(int seconds) {
        Period period = new Period((Object)Seconds.seconds((int)seconds));
        return period.toStandardHours().getHours();
    }

    public static int SECONDS_TO_MINUTES(int seconds) {
        Period period = new Period((Object)Seconds.seconds((int)seconds));
        return period.toStandardMinutes().getMinutes();
    }

    public static int SECONDS_TO_WEEKS(int seconds) {
        Period period = new Period((Object)Seconds.seconds((int)seconds));
        return period.toStandardWeeks().getWeeks();
    }

    public static boolean isDate(String value) {
        return TypeInference.isDate(value);
    }

    public static boolean isTime(String value) {
        return TypeInference.isTime(value);
    }

    private static DateTime getDateTime(ZonedDateTime zonedDateTime) {
        return new DateTime(zonedDateTime.toInstant().toEpochMilli(), DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(zonedDateTime.getZone())));
    }

    private static void validate(ZonedDateTime date, String method) {
        if (date == null) {
            throw new IllegalArgumentException(String.format("Date can not be null for %s", method));
        }
    }
}

