/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.xml;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.directives.parser.JsParser;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Numeric;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;
import org.json.JSONException;
import org.json.XML;

@Plugin(type="directive")
@Name(value="parse-xml-to-json")
@Categories(categories={"xml"})
@Description(value="Parses a XML document to JSON representation.")
public class XmlToJson
implements Directive,
Lineage {
    public static final String NAME = "parse-xml-to-json";
    private String col;
    private int depth;
    private final Gson gson = new Gson();

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("depth", TokenType.NUMERIC, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.col = ((ColumnName)args.value("column")).value();
        this.depth = args.contains("depth") ? ((Numeric)args.value("depth")).value().intValue() : Integer.MAX_VALUE;
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            int idx = row.find(this.col);
            if (idx == -1) continue;
            Object object = row.getValue(idx);
            if (object == null) {
                throw new DirectiveExecutionException(NAME, "' : Column '" + this.col + "' does not exist.");
            }
            try {
                if (object instanceof String) {
                    JsonObject element = ((JsonElement)this.gson.fromJson(XML.toJSONObject((String)((String)object)).toString(), JsonElement.class)).getAsJsonObject();
                    JsParser.jsonFlatten(element, this.col, 1, this.depth, row);
                    row.remove(idx);
                    continue;
                }
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' has invalid type '%s'. It should be of type 'String'.", this.col, object.getClass().getSimpleName()));
            }
            catch (JSONException e) {
                throw new DirectiveExecutionException(NAME, e.getMessage(), (Throwable)e);
            }
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Converted xml in column '%s' to json", new Object[]{this.col}).all(Many.of((String[])new String[]{this.col})).build();
    }
}

