/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.writer;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonObject;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.ColumnNameList;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;

@Plugin(type="directive")
@Name(value="write-as-json-object")
@Categories(categories={"writer", "json"})
@Description(value="Creates a JSON object based on source columns specified. JSON object is written into dest-column.")
public class WriteAsJsonObject
implements Directive,
Lineage {
    public static final String NAME = "write-as-json-object";
    private String column;
    private List<String> columns;
    private Gson gson;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("col", TokenType.COLUMN_NAME_LIST, true);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.columns = ((ColumnNameList)args.value("col")).value();
        this.gson = new Gson();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            JsonObject object = new JsonObject();
            for (String col : this.columns) {
                Object value = row.getValue(col);
                if (value instanceof Integer) {
                    object.addProperty(col, (Number)((Integer)value));
                    continue;
                }
                if (value instanceof Long) {
                    object.addProperty(col, (Number)((Long)value));
                    continue;
                }
                if (value instanceof Number) {
                    object.addProperty(col, (Number)value);
                    continue;
                }
                if (value instanceof Float) {
                    object.addProperty(col, (Number)((Float)value));
                    continue;
                }
                if (value instanceof Double) {
                    object.addProperty(col, (Number)((Double)value));
                    continue;
                }
                if (value instanceof Short) {
                    object.addProperty(col, (Number)((Short)value));
                    continue;
                }
                if (value instanceof Character) {
                    object.addProperty(col, Character.toString(((Character)value).charValue()));
                    continue;
                }
                if (value instanceof String) {
                    object.addProperty(col, (String)value);
                    continue;
                }
                if (value instanceof JsonElement) {
                    object.add(col, (JsonElement)value);
                    continue;
                }
                if (!(value instanceof JsonNull)) continue;
                object.add(col, (JsonElement)((JsonNull)value));
            }
            row.addOrSet(this.column, (Object)object);
        }
        return rows;
    }

    public Mutation lineage() {
        Mutation.Builder builder = Mutation.builder().readable("Wrote columns '%s' as json object into column '%s'", new Object[]{this.columns, this.column});
        builder.relation(Many.of(this.columns), this.column);
        this.columns.forEach(column -> builder.relation(column, column));
        return builder.build();
    }
}

