/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.writer;

import com.google.gson.Gson;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Pair;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.HashMap;
import java.util.List;

@Plugin(type="directive")
@Name(value="write-as-json-map")
@Categories(categories={"writer", "json"})
@Description(value="Writes all record columns as JSON map.")
public class WriteAsJsonMap
implements Directive,
Lineage {
    public static final String NAME = "write-as-json-map";
    private String column;
    private Gson gson;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.gson = new Gson();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            HashMap<Object, Object> toJson = new HashMap<Object, Object>();
            for (Pair entry : row.getFields()) {
                toJson.put(entry.getFirst(), entry.getSecond());
            }
            row.addOrSet(this.column, (Object)this.gson.toJson(toJson));
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Wrote column '%s' as a json map", new Object[]{this.column}).generate(Many.of((String[])new String[]{this.column})).build();
    }
}

