/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.writer;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

@Plugin(type="directive")
@Name(value="write-as-csv")
@Categories(categories={"writer", "csv"})
@Description(value="Writes the records files as well-formatted CSV")
public class WriteAsCSV
implements Directive,
Lineage {
    public static final String NAME = "write-as-csv";
    private String column;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            try {
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(bOut));){
                    CSVPrinter csvPrinter = new CSVPrinter((Appendable)out, CSVFormat.DEFAULT);
                    for (int i = 0; i < row.width(); ++i) {
                        csvPrinter.print(row.getValue(i));
                    }
                    csvPrinter.flush();
                    csvPrinter.close();
                }
                catch (Exception e) {
                    bOut.close();
                }
                row.add(this.column, (Object)bOut.toString());
            }
            catch (IOException e) {
                throw new DirectiveExecutionException(NAME, e.getMessage(), (Throwable)e);
            }
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Wrote column '%s' in the common separated value (CSV) format", new Object[]{this.column}).generate(Many.of((String[])new String[]{this.column})).build();
    }
}

