/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.validation;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.directives.validation.ConformanceIssue;
import io.cdap.directives.validation.conformers.Conformer;
import io.cdap.directives.validation.conformers.JsonConformer;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ErrorRowException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.ReportErrorAndProceed;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Identifier;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.utils.Manifest;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Plugin(type="directive")
@Name(value="validate-standard")
@Categories(categories={"data-quality"})
@Description(value="Checks a column against a standard schema")
public class ValidateStandard
implements Directive {
    public static final String NAME = "validate-standard";
    static final String SCHEMAS_RESOURCE_PATH = "schemas/";
    static final String MANIFEST_PATH = "schemas/manifest.json";
    static final Map<String, Conformer.Factory<JsonObject>> FORMAT_TO_FACTORY = new HashMap<String, Conformer.Factory<JsonObject>>();
    private static final Logger LOG = LoggerFactory.getLogger(ValidateStandard.class);
    private static final String STANDARD_SPEC = "standard-spec";
    private static final String COLUMN = "column";
    private static final Map<String, Conformer<JsonObject>> schemaToConformer = new HashMap<String, Conformer<JsonObject>>();
    private static Manifest standardsManifest = null;
    private String column;
    private String schema;

    private static Manifest getManifest() throws IOException {
        InputStream resourceStream = ValidateStandard.class.getClassLoader().getResourceAsStream(MANIFEST_PATH);
        if (resourceStream == null) {
            throw new IOException(String.format("Can't read/find resource %s", MANIFEST_PATH));
        }
        InputStream manifestStream = ValidateStandard.readResource(MANIFEST_PATH);
        return (Manifest)new Gson().getAdapter(Manifest.class).fromJson((Reader)new InputStreamReader(manifestStream));
    }

    private static InputStream readResource(String name) {
        InputStream resourceStream = ValidateStandard.class.getClassLoader().getResourceAsStream(name);
        if (resourceStream == null) {
            throw new IllegalArgumentException("Can't read/find resource " + name);
        }
        return resourceStream;
    }

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define(COLUMN, TokenType.COLUMN_NAME);
        builder.define(STANDARD_SPEC, TokenType.IDENTIFIER, String.format("[one of: %s]", String.join((CharSequence)", ", standardsManifest.getStandards().keySet())));
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value(COLUMN)).value();
        String spec = ((Identifier)args.value(STANDARD_SPEC)).value();
        if (spec.equals("")) {
            throw new DirectiveParseException("No standard specified to validate against");
        }
        if (standardsManifest == null) {
            throw new DirectiveParseException("Standards manifest was not loaded. Please check logs for information");
        }
        Map<String, Manifest.Standard> availableSpecs = standardsManifest.getStandards();
        if (!availableSpecs.containsKey(spec)) {
            throw new DirectiveParseException(String.format("Unknown standard %s. Known values are %s", spec, String.join((CharSequence)", ", standardsManifest.getStandards().keySet())));
        }
        Manifest.Standard standard = availableSpecs.get(spec);
        this.schema = Paths.get(SCHEMAS_RESOURCE_PATH, String.format("%s.%s", spec, standard.getFormat())).toString();
        if (!schemaToConformer.containsKey(this.schema)) {
            if (!FORMAT_TO_FACTORY.containsKey(standard.getFormat())) {
                throw new DirectiveParseException(String.format("No validator for format %s", standard.getFormat()));
            }
            try {
                Conformer<JsonObject> conformer = FORMAT_TO_FACTORY.get(standard.getFormat()).setSchemaStreamSupplier(() -> ValidateStandard.readResource(this.schema)).build();
                conformer.initialize();
                schemaToConformer.put(this.schema, conformer);
            }
            catch (IOException e) {
                throw new DirectiveParseException(String.format("Unable to read standard schema: %s", e.getMessage()), (Throwable)e);
            }
        }
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException, ErrorRowException, ReportErrorAndProceed {
        for (Row row : rows) {
            Object object;
            int idx = row.find(this.column);
            if (idx < 0 || (object = row.getValue(idx)) == null) continue;
            if (!(object instanceof JsonObject)) {
                throw new DirectiveExecutionException(String.format("Column %s is not a %s (it's %s)", this.column, JsonObject.class.getName(), object.getClass().getName()));
            }
            Conformer<JsonObject> conformer = schemaToConformer.get(this.schema);
            if (conformer == null) {
                throw new DirectiveExecutionException("Directive was not initialized for schema " + this.schema);
            }
            List<ConformanceIssue> conformanceIssues = conformer.checkConformance((JsonObject)object);
            if (conformanceIssues.size() <= 0) continue;
            throw new ErrorRowException(conformanceIssues.stream().map(ConformanceIssue::toString).collect(Collectors.joining("; ")), 1, true);
        }
        return rows;
    }

    public void destroy() {
    }

    static {
        FORMAT_TO_FACTORY.put("json", new JsonConformer.Factory());
        try {
            standardsManifest = ValidateStandard.getManifest();
        }
        catch (IOException e) {
            LOG.error("Unable to read standards manifest", (Throwable)e);
        }
    }
}

