/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.List;

@Plugin(type="directive")
@Name(value="url-encode")
@Categories(categories={"transform"})
@Description(value="URL encode a column value.")
public class UrlEncode
implements Directive,
Lineage {
    public static final String NAME = "url-encode";
    private String column;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
    }

    public void destroy() {
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Encoded column '%s' as url", new Object[]{this.column}).relation(this.column, this.column).build();
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            int idx = row.find(this.column);
            if (idx != -1) {
                Object object = row.getValue(idx);
                if (object == null) {
                    throw new DirectiveExecutionException(NAME, String.format("Column '%s' has null value. It should be a non-null 'String'.", this.column));
                }
                if (object instanceof String) {
                    try {
                        row.setValue(idx, (Object)URLEncoder.encode((String)object, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    continue;
                }
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' has invalid type '%s'. It should be of type 'String'.", this.column, object.getClass().getSimpleName()));
            }
            throw new DirectiveExecutionException(NAME, String.format("Column '%s' does not exist.", this.column));
        }
        return rows;
    }
}

