/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;
import org.simmetrics.StringMetric;
import org.simmetrics.metrics.StringMetrics;

@Plugin(type="directive")
@Name(value="text-metric")
@Categories(categories={"transform"})
@Description(value="Calculates the metric for comparing two string values.")
public class TextMetricMeasure
implements Directive,
Lineage {
    public static final String NAME = "text-metric";
    private String column1;
    private String column2;
    private String destination;
    private StringMetric metric;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("method", TokenType.TEXT);
        builder.define("column1", TokenType.COLUMN_NAME);
        builder.define("column2", TokenType.COLUMN_NAME);
        builder.define("destination", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        String method = ((Text)args.value("method")).value();
        this.column1 = ((ColumnName)args.value("column1")).value();
        this.column2 = ((ColumnName)args.value("column2")).value();
        this.destination = ((ColumnName)args.value("destination")).value();
        switch (method.toLowerCase()) {
            case "euclidean": {
                this.metric = StringMetrics.euclideanDistance();
                break;
            }
            case "block-metric": {
                this.metric = StringMetrics.blockDistance();
                break;
            }
            case "identity": {
                this.metric = StringMetrics.identity();
                break;
            }
            case "block": {
                this.metric = StringMetrics.blockDistance();
                break;
            }
            case "dice": {
                this.metric = StringMetrics.dice();
                break;
            }
            case "longest-common-subsequence": {
                this.metric = StringMetrics.longestCommonSubsequence();
                break;
            }
            case "longest-common-substring": {
                this.metric = StringMetrics.longestCommonSubstring();
                break;
            }
            case "overlap-cofficient": {
                this.metric = StringMetrics.overlapCoefficient();
                break;
            }
            case "jaccard": {
                this.metric = StringMetrics.jaccard();
                break;
            }
            case "damerau-levenshtein": {
                this.metric = StringMetrics.damerauLevenshtein();
                break;
            }
            case "generalized-jaccard": {
                this.metric = StringMetrics.generalizedJaccard();
                break;
            }
            case "jaro": {
                this.metric = StringMetrics.jaro();
                break;
            }
            case "simon-white": {
                this.metric = StringMetrics.simonWhite();
                break;
            }
            case "levenshtein": {
                this.metric = StringMetrics.levenshtein();
                break;
            }
            default: {
                this.metric = StringMetrics.cosineSimilarity();
            }
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            int idx1 = row.find(this.column1);
            int idx2 = row.find(this.column2);
            if (idx1 == -1 || idx2 == -1) {
                row.add(this.destination, (Object)Float.valueOf(0.0f));
                continue;
            }
            Object object1 = row.getValue(idx1);
            Object object2 = row.getValue(idx2);
            if (object1 == null || object2 == null) {
                row.add(this.destination, (Object)Float.valueOf(0.0f));
                continue;
            }
            if (!(object1 instanceof String) || !(object2 instanceof String)) {
                row.add(this.destination, (Object)Float.valueOf(0.0f));
                continue;
            }
            if (((String)object1).isEmpty() || ((String)object2).isEmpty()) {
                row.add(this.destination, (Object)Float.valueOf(0.0f));
                continue;
            }
            row.add(this.destination, (Object)Float.valueOf(this.metric.compare((String)object1, (String)object2)));
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Compared text in columns '%s' and '%s' and saved it in column '%s'", new Object[]{this.column1, this.column2, this.destination}).relation(Many.columns((String[])new String[]{this.column1, this.column2}), this.destination).relation(this.column1, this.column1).relation(this.column2, this.column2).build();
    }
}

