/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Pair;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Many;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;

@Plugin(type="directive")
@Name(value="split-email")
@Categories(categories={"transform", "email"})
@Description(value="Split a email into account and domain.")
public class SplitEmail
implements Directive,
Lineage {
    public static final String NAME = "split-email";
    private String column;
    private String generatedAccountCol;
    private String generatedDomainCol;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.generatedAccountCol = this.column + "_account";
        this.generatedDomainCol = this.column + "_domain";
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            int idx = row.find(this.column);
            if (idx != -1) {
                Object object = row.getValue(idx);
                if (object == null) {
                    row.add(this.generatedAccountCol, null);
                    row.add(this.generatedDomainCol, null);
                    continue;
                }
                if (object instanceof String) {
                    String emailAddress = (String)object;
                    int nameIdx = emailAddress.lastIndexOf("<");
                    if (nameIdx == -1) {
                        Pair<String, String> components = this.extractDomainAndAccount(emailAddress);
                        row.add(this.generatedAccountCol, components.getFirst());
                        row.add(this.generatedDomainCol, components.getSecond());
                        continue;
                    }
                    String name = emailAddress.substring(0, nameIdx);
                    int endIdx = emailAddress.lastIndexOf(">");
                    if (endIdx == -1) {
                        row.add(this.generatedAccountCol, null);
                        row.add(this.generatedDomainCol, null);
                        continue;
                    }
                    emailAddress = emailAddress.substring(nameIdx + 1, endIdx);
                    Pair<String, String> components = this.extractDomainAndAccount(emailAddress);
                    row.add(this.generatedAccountCol, components.getFirst());
                    row.add(this.generatedDomainCol, components.getSecond());
                    continue;
                }
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' has invalid type '%s'. It should be of type 'String'.", this.column, object.getClass().getSimpleName()));
            }
            throw new DirectiveExecutionException(NAME, String.format("Column '%s' does not exist.", this.column));
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Split column '%s' into columns '%s' and '%s'", new Object[]{this.column, this.generatedAccountCol, this.generatedDomainCol}).relation(this.column, Many.of((String[])new String[]{this.column, this.generatedAccountCol, this.generatedDomainCol})).build();
    }

    private Pair<String, String> extractDomainAndAccount(String emailId) {
        int lastidx = emailId.lastIndexOf("@");
        if (lastidx == -1) {
            return new Pair(null, null);
        }
        return new Pair((Object)emailId.substring(0, lastidx), (Object)emailId.substring(lastidx + 1));
    }
}

