/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import com.google.common.base.Strings;
import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.List;

@Plugin(type="directive")
@Name(value="split")
@Categories(categories={"readable"})
@Description(value="Use 'split-to-columns' or 'split-to-rows'.")
@Deprecated
public class Split
implements Directive {
    public static final String NAME = "split";
    private String col;
    private String delimiter;
    private String firstColumnName;
    private String secondColumnName;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("source", TokenType.COLUMN_NAME);
        builder.define("delimiter", TokenType.TEXT);
        builder.define("column1", TokenType.COLUMN_NAME);
        builder.define("column2", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.col = ((ColumnName)args.value("source")).value();
        this.delimiter = ((Text)args.value("delimiter")).value();
        this.firstColumnName = ((ColumnName)args.value("column1")).value();
        this.secondColumnName = ((ColumnName)args.value("column2")).value();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            int idx = row.find(this.col);
            if (idx != -1) {
                String val = (String)row.getValue(idx);
                if (val != null) {
                    String[] parts = val.split(this.delimiter, 2);
                    if (Strings.isNullOrEmpty((String)parts[0])) {
                        row.add(this.firstColumnName, (Object)parts[1]);
                        row.add(this.secondColumnName, null);
                    } else {
                        row.add(this.firstColumnName, (Object)parts[0]);
                        row.add(this.secondColumnName, (Object)parts[1]);
                    }
                } else {
                    row.add(this.firstColumnName, null);
                    row.add(this.secondColumnName, null);
                }
            } else {
                throw new DirectiveExecutionException(this.col + " is not of type string. Please check the wrangle configuration.");
            }
            results.add(row);
        }
        return results;
    }
}

