/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import io.cdap.wrangler.utils.TypeConvertor;
import java.util.List;

@Plugin(type="directive")
@Name(value="mask-number")
@Categories(categories={"transform"})
@Description(value="Masks a column value using the specified masking pattern.")
public class MaskNumber
implements Directive,
Lineage {
    public static final String NAME = "mask-number";
    public static final int MASK_NUMBER = 1;
    public static final int MASK_SHUFFLE = 2;
    private String mask;
    private String column;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("mask", TokenType.TEXT);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.mask = ((Text)args.value("mask")).value();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            int idx = row.find(this.column);
            if (idx != -1) {
                String value = TypeConvertor.toString(row.getValue(idx));
                if (value == null) continue;
                row.setValue(idx, (Object)this.maskNumber(value, this.mask));
                continue;
            }
            row.add(this.column, (Object)new String(""));
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Masked numbers in the column '%s' using masking pattern '%s'", new Object[]{this.column, this.mask}).relation(this.column, this.column).build();
    }

    private String maskNumber(String number, String mask) {
        int index = 0;
        StringBuilder masked = new StringBuilder();
        for (int i = 0; i < mask.length(); ++i) {
            char c1;
            char c = mask.charAt(i);
            if (c == '#') {
                if (index > number.length() - 1) continue;
                masked.append(number.charAt(index));
                ++index;
                continue;
            }
            if (c == 'x' || c == 'X') {
                masked.append(Character.toLowerCase(c));
                ++index;
                continue;
            }
            if (index < number.length() && (c1 = number.charAt(index)) == c) {
                ++index;
            }
            masked.append(c);
        }
        return masked.toString();
    }
}

