/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Numeric;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.List;

@Plugin(type="directive")
@Name(value="indexsplit")
@Categories(categories={"transform"})
@Description(value="[DEPRECATED] Use the 'split-to-columns' or 'parse-as-fixed-length' directives instead.")
@Deprecated
public class IndexSplit
implements Directive {
    public static final String NAME = "indexsplit";
    private String col;
    private int start;
    private int end;
    private String dest;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("source", TokenType.COLUMN_NAME);
        builder.define("start", TokenType.NUMERIC);
        builder.define("end", TokenType.NUMERIC);
        builder.define("destination", TokenType.COLUMN_NAME);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.col = ((ColumnName)args.value("source")).value();
        this.start = ((Numeric)args.value("start")).value().intValue();
        this.end = ((Numeric)args.value("end")).value().intValue();
        this.dest = ((ColumnName)args.value("destination")).value();
        --this.start;
        --this.end;
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            String val;
            int idx = row.find(this.col);
            if (idx != -1) {
                val = (String)row.getValue(idx);
                if (this.end > val.length() - 1) {
                    this.end = val.length() - 1;
                }
                if (this.start < 0) {
                    this.start = 0;
                }
            } else {
                throw new DirectiveExecutionException(this.col + " is not of type string in the row. Please check the wrangle configuration.");
            }
            val = val.substring(this.start, this.end);
            row.add(this.dest, (Object)val);
            results.add(row);
        }
        return results;
    }
}

