/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnNameList;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.ArrayList;
import java.util.List;
import org.unix4j.Unix4j;
import org.unix4j.builder.Unix4jCommandBuilder;

@Plugin(type="directive")
@Name(value="find-and-replace")
@Categories(categories={"transform"})
@Description(value="Finds and replaces text in column values using a sed-format expression.")
public class FindAndReplace
implements Directive,
Lineage {
    public static final String NAME = "find-and-replace";
    private String pattern;
    private List<String> columns;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME_LIST);
        builder.define("pattern", TokenType.TEXT);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.columns = ((ColumnNameList)args.value("column")).value();
        this.pattern = ((Text)args.value("pattern")).value();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        ArrayList<Row> results = new ArrayList<Row>();
        for (Row row : rows) {
            for (String column : this.columns) {
                int idx = row.find(column);
                if (idx != -1) {
                    Object v = row.getValue(idx);
                    try {
                        if (v instanceof String) {
                            String value = (String)v;
                            Unix4jCommandBuilder builder = Unix4j.echo((String[])new String[]{value}).sed(this.pattern);
                            if (builder.toExitValue() == 0) {
                                row.setValue(idx, (Object)builder.toStringResult());
                            }
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                results.add(row);
            }
        }
        return results;
    }

    public Mutation lineage() {
        Mutation.Builder builder = Mutation.builder().readable("Found and replaced '%s' using expression '%s'", new Object[]{this.columns, this.pattern});
        this.columns.forEach(column -> builder.relation(column, column));
        return builder.build();
    }
}

