/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;
import org.json.JSONObject;

@Plugin(type="directive")
@Name(value="fill-null-or-empty")
@Categories(categories={"transform"})
@Description(value="Fills a value of a column with a fixed value if it is either null or empty.")
public class FillNullOrEmpty
implements Directive,
Lineage {
    public static final String NAME = "fill-null-or-empty";
    private String column;
    private String value;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("column", TokenType.COLUMN_NAME);
        builder.define("value", TokenType.TEXT);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.column = ((ColumnName)args.value("column")).value();
        this.value = ((Text)args.value("value")).value();
        if (this.value != null && this.value.isEmpty()) {
            throw new DirectiveParseException(NAME, "Fixed value cannot be an empty string");
        }
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            int idx = row.find(this.column);
            if (idx == -1) {
                row.add(this.column, (Object)this.value);
                continue;
            }
            Object object = row.getValue(idx);
            if (object == null) {
                row.setValue(idx, (Object)this.value);
                continue;
            }
            if (object instanceof String) {
                if (!((String)object).isEmpty()) continue;
                row.setValue(idx, (Object)this.value);
                continue;
            }
            if (!(object instanceof JSONObject) || !JSONObject.NULL.equals(object)) continue;
            row.setValue(idx, (Object)this.value);
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable("Filled column '%s' values that were null or empty with value %s", new Object[]{this.column, this.value}).relation(this.column, this.column).build();
    }
}

