/*
 * Decompiled with CFR 0.152.
 */
package io.cdap.directives.transformation;

import io.cdap.cdap.api.annotation.Description;
import io.cdap.cdap.api.annotation.Name;
import io.cdap.cdap.api.annotation.Plugin;
import io.cdap.wrangler.api.Arguments;
import io.cdap.wrangler.api.Directive;
import io.cdap.wrangler.api.DirectiveExecutionException;
import io.cdap.wrangler.api.DirectiveParseException;
import io.cdap.wrangler.api.ExecutorContext;
import io.cdap.wrangler.api.Row;
import io.cdap.wrangler.api.annotations.Categories;
import io.cdap.wrangler.api.lineage.Lineage;
import io.cdap.wrangler.api.lineage.Mutation;
import io.cdap.wrangler.api.parser.ColumnName;
import io.cdap.wrangler.api.parser.Text;
import io.cdap.wrangler.api.parser.TokenType;
import io.cdap.wrangler.api.parser.UsageDefinition;
import java.util.List;
import org.unix4j.Unix4j;

@Plugin(type="directive")
@Name(value="cut-character")
@Categories(categories={"transform"})
@Description(value="UNIX-like 'cut' directive for splitting text.")
public class CharacterCut
implements Directive,
Lineage {
    public static final String NAME = "cut-character";
    private String source;
    private String destination;
    private String range;

    public UsageDefinition define() {
        UsageDefinition.Builder builder = UsageDefinition.builder((String)NAME);
        builder.define("source", TokenType.COLUMN_NAME);
        builder.define("destination", TokenType.COLUMN_NAME);
        builder.define("ranges", TokenType.TEXT);
        return builder.build();
    }

    public void initialize(Arguments args) throws DirectiveParseException {
        this.source = ((ColumnName)args.value("source")).value();
        this.destination = ((ColumnName)args.value("destination")).value();
        this.range = ((Text)args.value("ranges")).value();
    }

    public void destroy() {
    }

    public List<Row> execute(List<Row> rows, ExecutorContext context) throws DirectiveExecutionException {
        for (Row row : rows) {
            int idx = row.find(this.source);
            if (idx != -1) {
                Object value = row.getValue(idx);
                if (value == null) {
                    throw new DirectiveExecutionException(NAME, String.format("Column '%s' has null value. It should be a non-null 'String'.", this.source));
                }
                if (value instanceof String) {
                    String result = Unix4j.fromString((String)((String)value)).cut(new String[]{"-c", this.range}).toStringResult();
                    row.addOrSet(this.destination, (Object)result);
                    continue;
                }
                throw new DirectiveExecutionException(NAME, String.format("Column '%s' has invalid type '%s'. It should be of type 'String'.", this.source, value.getClass().getSimpleName()));
            }
            throw new DirectiveExecutionException(NAME, "Scope column '" + this.source + "' does not exist.");
        }
        return rows;
    }

    public Mutation lineage() {
        return Mutation.builder().readable(String.format("Character cut from column %s to destination %s using range %s", this.source, this.destination, this.range), new Object[0]).conditional(this.source, this.destination).build();
    }
}

